/*
 * Decompiled with CFR 0.152.
 */
package com.amotassic.dabaosword.item.tool;

import com.amotassic.dabaosword.api.CardPileInventory;
import com.amotassic.dabaosword.ui.PileScreenHandler;
import com.amotassic.dabaosword.util.Gamerule;
import com.amotassic.dabaosword.util.ModTools;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurioItem;

public class CardPile
extends Item
implements ICurioItem {
    public CardPile() {
        super(new Item.Properties().stacksTo(1));
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag tooltipFlag) {
        tooltip.add((Component)Component.translatable((String)"item.dabaosword.card_pile.tooltip"));
        tooltip.add((Component)Component.empty());
        tooltip.add((Component)Component.translatable((String)"item.dabaosword.card_pile.tip1").withStyle(ChatFormatting.BOLD));
        tooltip.add((Component)Component.translatable((String)"item.dabaosword.card_pile.tip2", (Object[])new Object[]{Component.keybind((String)"key.dabaosword.select_card")}).withStyle(ChatFormatting.BOLD));
        tooltip.add((Component)Component.translatable((String)"item.dabaosword.card_pile.tip3", (Object[])new Object[]{Component.keybind((String)"key.sprint"), Component.keybind((String)"key.dabaosword.select_card")}).withStyle(ChatFormatting.BOLD));
        tooltip.add((Component)Component.translatable((String)"item.dabaosword.card_pile.tip4", (Object[])new Object[]{Component.keybind((String)"key.sprint"), Component.keybind((String)"key.sneak"), Component.keybind((String)"key.dabaosword.select_card")}).withStyle(ChatFormatting.BOLD));
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        LivingEntity entity = slotContext.entity();
        Level level = entity.level();
        if (level instanceof ServerLevel) {
            ServerLevel world = (ServerLevel)level;
            if (entity instanceof Player) {
                Player player = (Player)entity;
                long time = world.getGameTime();
                int skill = world.getGameRules().getInt(Gamerule.CHANGE_SKILL_INTERVAL) * 20;
                if (world.getGameRules().getBoolean(Gamerule.CARD_PILE_HUNGERLESS)) {
                    player.getFoodData().setFoodLevel(20);
                }
                if (skill >= 0) {
                    if (skill == 0) {
                        player.addTag("change_skill");
                    } else if (time % (long)skill == 0L) {
                        player.addTag("change_skill");
                        if (skill >= 600) {
                            player.displayClientMessage((Component)Component.translatable((String)"dabaosword.change_skill").withStyle(ChatFormatting.BOLD), false);
                            player.displayClientMessage((Component)Component.translatable((String)"dabaosword.change_skill2"), false);
                        }
                    }
                }
                if (player.containerMenu.getClass() != PileScreenHandler.class && time % 20L == 0L) {
                    CardPileInventory cards = ModTools.getCardPack(player);
                    for (int i = 9; i < 36; ++i) {
                        ItemStack item = (ItemStack)player.getInventory().items.get(i);
                        if (!ModTools.isCard(item) || !cards.isNotFull()) continue;
                        cards.insertStack(item.copy());
                        item.setCount(0);
                    }
                }
            }
        }
    }
}

