/*
 * Decompiled with CFR 0.152.
 */
package com.amotassic.dabaosword.mixin;

import java.util.Set;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={AbstractArrow.class})
abstract class ArrowEntityMixin
extends Projectile {
    @Shadow
    protected boolean inGround;

    protected ArrowEntityMixin(EntityType<? extends Projectile> entityType, Level level) {
        super(entityType, level);
    }

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    public void tick(CallbackInfo ci) {
        Set tags = this.getTags();
        if (this.inGround && (tags.contains("a") || tags.contains("cosmetic"))) {
            this.discard();
        }
    }

    @Inject(method={"onHitEntity"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;setRemainingFireTicks(I)V")})
    private void onHit(EntityHitResult result, CallbackInfo ci) {
        if (this.getTags().contains("a")) {
            this.discard();
        }
    }

    @Inject(method={"onHitEntity"}, at={@At(value="HEAD")}, cancellable=true)
    private void cosmetic(EntityHitResult entityHitResult, CallbackInfo ci) {
        if (this.getTags().contains("cosmetic")) {
            this.discard();
            ci.cancel();
        }
    }
}

