/*
 * Decompiled with CFR 0.152.
 */
package com.amotassic.dabaosword.mixin;

import com.amotassic.dabaosword.damage_type.ModDT;
import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.player.Player;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Entity.class})
abstract class EntityMixin {
    EntityMixin() {
    }

    @Shadow
    public abstract boolean hurt(DamageSource var1, float var2);

    @Inject(method={"thunderHit"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;hurt(Lnet/minecraft/world/damagesource/DamageSource;F)Z")}, cancellable=true)
    public void onStruckByLightning(ServerLevel world, LightningBolt lightning, CallbackInfo ci) {
        if (lightning.getTags().contains("a")) {
            this.hurt(ModDT.shandian((Entity)lightning), lightning.getDamage());
            ci.cancel();
        }
    }

    @ModifyReturnValue(method={"dampensVibrations"}, at={@At(value="RETURN")})
    public boolean occludeVibrationSignals(boolean original) {
        Player player;
        Entity entity = (Entity)this;
        if (entity instanceof Player && (player = (Player)entity).getTags().contains("wuyan")) {
            return true;
        }
        return original;
    }
}

