/*
 * Decompiled with CFR 0.152.
 */
package com.amotassic.dabaosword.mixin;

import com.amotassic.dabaosword.item.ModItems;
import com.amotassic.dabaosword.util.ModTools;
import java.util.HashSet;
import java.util.UUID;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ItemEntity.class})
abstract class ItemEntityMixin
extends Entity {
    @Shadow
    private UUID target;
    @Unique
    ItemEntity thisItem = (ItemEntity)this;

    public ItemEntityMixin(EntityType<?> entityType, Level level) {
        super(entityType, level);
    }

    @Shadow
    public abstract ItemStack getItem();

    @Shadow
    public abstract void setNoPickUpDelay();

    @Shadow
    public abstract void setItem(ItemStack var1);

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    public void tick(CallbackInfo ci) {
        Villager villager;
        ItemEntity item;
        Entity entity;
        ItemStack stack;
        Level level;
        if (ModTools.isCard(this.getItem())) {
            this.setNoPickUpDelay();
        }
        if ((level = this.level()) instanceof ServerLevel) {
            ServerLevel world = (ServerLevel)level;
            Entity follow = world.getEntity(this.target);
            if (world.getGameTime() % 20L == 0L && this.getTags().contains("follow_owner") && follow != null) {
                this.teleportTo((ServerLevel)follow.level(), follow.getX(), follow.getY(), follow.getZ(), new HashSet(), this.getYRot(), this.getXRot());
            }
        }
        if ((stack = this.getItem()).is(Items.ARROW) && stack.getCount() == 64 && (entity = ModTools.getClosestEntity((Entity)this.thisItem, Entity.class, 0.2, e -> true)) instanceof ItemEntity && (item = (ItemEntity)entity).getItem().is(Items.BOW)) {
            item.setItem(new ItemStack((ItemLike)ModItems.ARROW_RAIN));
            this.discard();
        }
        if (stack.is(Items.EMERALD) && stack.getCount() == 64 && (entity = ModTools.getClosestEntity((Entity)this.thisItem, Entity.class, 0.2, e -> true)) instanceof Villager && (villager = (Villager)entity).getVillagerData().getProfession() == VillagerProfession.NITWIT) {
            this.setItem(new ItemStack((ItemLike)ModItems.GIFTBOX, 1));
        }
    }
}

