/*
 * Decompiled with CFR 0.152.
 */
package com.amotassic.dabaosword.mixin;

import com.amotassic.dabaosword.item.ModItems;
import com.amotassic.dabaosword.item.card.CardItem;
import com.amotassic.dabaosword.util.ModTools;
import java.util.Arrays;
import java.util.Random;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Mob.class})
public abstract class MobEntityMixin
extends LivingEntity {
    @Unique
    Mob mob = (Mob)this;

    protected MobEntityMixin(EntityType<? extends LivingEntity> entityType, Level level) {
        super(entityType, level);
    }

    @Inject(method={"populateDefaultEquipmentSlots"}, at={@At(value="TAIL")})
    protected void initEquipment(RandomSource random, DifficultyInstance localDifficulty, CallbackInfo ci) {
        if (!this.level().isClientSide) {
            Random random2 = new Random();
            if (random2.nextFloat() < this.getChance()) {
                this.initCards();
            }
        }
    }

    @Inject(method={"doHurtTarget"}, at={@At(value="HEAD")})
    public void tryAttack(Entity target, CallbackInfoReturnable<Boolean> cir) {
        if (ModTools.isCard(this.getMainHandItem()) && target instanceof LivingEntity) {
            this.tryUseCard(this.getMainHandItem(), (LivingEntity)target);
        }
    }

    @Unique
    private void tryUseCard(ItemStack stack, LivingEntity target) {
        if (!ModTools.isBasic.test(stack) && !stack.is((Item)ModItems.WUXIE)) {
            CardItem.onUse((LivingEntity)this.mob, stack, null, target);
        }
    }

    @Unique
    private float getChance() {
        Difficulty difficulty = this.level().getDifficulty();
        if (difficulty == Difficulty.EASY) {
            return 0.3f;
        }
        if (difficulty == Difficulty.NORMAL) {
            return 0.6f;
        }
        if (difficulty == Difficulty.HARD) {
            return 0.9f;
        }
        return 0.0f;
    }

    @Unique
    private void initCards() {
        if (this.getMainHandItem().isEmpty()) {
            this.setItemInHand(InteractionHand.MAIN_HAND, ModTools.newCard(this.getMainCard()).copyWithCount((int)(3.0 * Math.random()) + 1));
        }
        if (this.getOffhandItem().isEmpty()) {
            this.setItemInHand(InteractionHand.OFF_HAND, ModTools.newCard(this.getOffCard()).copyWithCount((int)(2.0 * Math.random()) + 1));
        }
    }

    @Unique
    private Item getMainCard() {
        Random random = new Random();
        if ((double)random.nextFloat() > 0.33) {
            Item[] items = new Item[]{ModItems.BINGLIANG_ITEM, ModItems.TOO_HAPPY_ITEM, ModItems.DISCARD, ModItems.FIRE_ATTACK, ModItems.JIEDAO, ModItems.WANJIAN, ModItems.TIESUO, ModItems.NANMAN, ModItems.JUEDOU, ModItems.SHANDIAN_ITEM};
            int index = new Random().nextInt(items.length);
            return Arrays.stream(items).toList().get(index);
        }
        return ModItems.SHA;
    }

    @Unique
    private Item getOffCard() {
        Random random = new Random();
        if ((double)random.nextFloat() < 0.5) {
            return ModItems.SHAN;
        }
        return ModItems.PEACH;
    }
}

