/*
 * Decompiled with CFR 0.152.
 */
package com.amotassic.dabaosword.mixin;

import java.util.Objects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Ravager;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Ravager.class})
public abstract class RavagerMixin
extends Raider {
    @Shadow
    private int stunnedTick;
    @Shadow
    private int roarTick;

    @Shadow
    protected abstract void strongKnockback(Entity var1);

    protected RavagerMixin(EntityType<? extends Raider> entityType, Level level) {
        super(entityType, level);
    }

    @Inject(method={"aiStep"}, at={@At(value="HEAD")})
    public void tickMovement(CallbackInfo ci) {
        if (this.getTags().contains("a")) {
            this.stunnedTick = 20;
            this.getTags().remove("a");
        }
        if (this.getTags().contains("b") && this.roarTick == 1) {
            this.discard();
        }
    }

    @Inject(method={"roar"}, at={@At(value="HEAD")}, cancellable=true)
    private void roar(CallbackInfo ci) {
        if (this.isAlive() && this.hasCustomName() && this.getTags().contains("b")) {
            int id = Integer.parseInt(Objects.requireNonNull(this.getCustomName()).getString());
            LivingEntity living = (LivingEntity)this.level().getEntity(id);
            if (living == null) {
                ci.cancel();
                return;
            }
            this.strongKnockback((Entity)living);
            ci.cancel();
        }
    }
}

