/*
 * Decompiled with CFR 0.152.
 */
package com.amotassic.dabaosword.mixin.client;

import com.amotassic.dabaosword.api.card.Card;
import com.amotassic.dabaosword.api.card.Rank;
import com.amotassic.dabaosword.api.card.Suit;
import com.amotassic.dabaosword.item.ModItems;
import com.amotassic.dabaosword.util.ModTools;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArgs;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.invoke.arg.Args;

@Mixin(value={GuiGraphics.class})
public abstract class DrawContextMixin {
    @Shadow
    @Final
    private PoseStack pose;
    @Shadow
    @Final
    private Minecraft minecraft;

    @Shadow
    abstract void blit(ResourceLocation var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, float var9, float var10, int var11, int var12);

    @Inject(method={"renderItemDecorations(Lnet/minecraft/client/gui/Font;Lnet/minecraft/world/item/ItemStack;IILjava/lang/String;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/item/ItemStack;isBarVisible()Z")})
    public void drawItemInSlot(Font font, ItemStack stack, int x, int y, String text, CallbackInfo ci) {
        Card card = ModTools.c(stack);
        Suit s = card.suit;
        Rank r = card.rank;
        if (s != Suit.None && r != Rank.None) {
            ResourceLocation suit = ResourceLocation.fromNamespaceAndPath((String)"dabaosword", (String)("textures/item/suit/" + this.getSuitName(s) + ".png"));
            ResourceLocation rank = ResourceLocation.fromNamespaceAndPath((String)"dabaosword", (String)("textures/item/rank2/" + this.getRankName(s, r) + ".png"));
            if (stack.getCount() == 1) {
                this.pose.translate(0.0f, 0.0f, 200.0f);
            }
            this.blit(suit, x, x + 5, y, y + 5, 0, 64, 64, 0.0f, 0.0f, 64, 64);
            this.blit(rank, x + 5, x + 11, y, y + 5, 0, 64, 64, 0.0f, 0.0f, 64, 64);
        }
    }

    @ModifyArgs(method={"renderItem(Lnet/minecraft/world/entity/LivingEntity;Lnet/minecraft/world/level/Level;Lnet/minecraft/world/item/ItemStack;IIII)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/renderer/entity/ItemRenderer;render(Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/item/ItemDisplayContext;ZLcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;IILnet/minecraft/client/resources/model/BakedModel;)V"))
    private void drawItem(Args args) {
        ItemStack stack = (ItemStack)args.get(0);
        if (ModTools.isCard(stack) || stack.is(ModItems.GAIN_CARD)) {
            String path = "card/" + stack.getItem().toString().split(":")[1];
            ModelResourceLocation modelId = ModelResourceLocation.inventory((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"dabaosword", (String)path));
            BakedModel model = this.minecraft.getItemRenderer().getItemModelShaper().getModelManager().getModel(modelId);
            args.set(7, (Object)model);
        }
    }

    @Unique
    private String getSuitName(Suit s) {
        return switch (s) {
            default -> throw new MatchException(null, null);
            case Suit.Heart -> "heart";
            case Suit.Diamond -> "diamond";
            case Suit.Spade -> "spade_w";
            case Suit.Club -> "club_w";
            case Suit.None -> "";
        };
    }

    @Unique
    private String getRankName(Suit s, Rank r) {
        return switch (s) {
            default -> throw new MatchException(null, null);
            case Suit.Heart, Suit.Diamond -> {
                switch (r) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case Ace: {
                        yield "ar";
                    }
                    case Two: {
                        yield "2r";
                    }
                    case Three: {
                        yield "3r";
                    }
                    case Four: {
                        yield "4r";
                    }
                    case Five: {
                        yield "5r";
                    }
                    case Six: {
                        yield "6r";
                    }
                    case Seven: {
                        yield "7r";
                    }
                    case Eight: {
                        yield "8r";
                    }
                    case Nine: {
                        yield "9r";
                    }
                    case Ten: {
                        yield "10r";
                    }
                    case Jack: {
                        yield "jr";
                    }
                    case Queen: {
                        yield "qr";
                    }
                    case King: {
                        yield "kr";
                    }
                    case None: 
                }
                yield "";
            }
            case Suit.Spade, Suit.Club -> {
                switch (r) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case Ace: {
                        yield "ab";
                    }
                    case Two: {
                        yield "2b";
                    }
                    case Three: {
                        yield "3b";
                    }
                    case Four: {
                        yield "4b";
                    }
                    case Five: {
                        yield "5b";
                    }
                    case Six: {
                        yield "6b";
                    }
                    case Seven: {
                        yield "7b";
                    }
                    case Eight: {
                        yield "8b";
                    }
                    case Nine: {
                        yield "9b";
                    }
                    case Ten: {
                        yield "10b";
                    }
                    case Jack: {
                        yield "jb";
                    }
                    case Queen: {
                        yield "qb";
                    }
                    case King: {
                        yield "kb";
                    }
                    case None: 
                }
                yield "";
            }
            case Suit.None -> "";
        };
    }
}

