/*
 * Decompiled with CFR 0.152.
 */
package com.amotassic.dabaosword.network;

import com.amotassic.dabaosword.api.skill.Skill;
import com.amotassic.dabaosword.item.ModItems;
import com.amotassic.dabaosword.item.skillcard.SkillCards;
import com.amotassic.dabaosword.network.ActiveSkillPayload;
import com.amotassic.dabaosword.network.QuickSwapPayload;
import com.amotassic.dabaosword.network.ShensuPayload;
import com.amotassic.dabaosword.ui.PileScreenHandler;
import com.amotassic.dabaosword.util.ModTools;
import com.amotassic.dabaosword.util.Tags;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Tuple;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;

@EventBusSubscriber(modid="dabaosword", bus=EventBusSubscriber.Bus.MOD)
public class ServerNetworking {
    @SubscribeEvent
    public static void register(RegisterPayloadHandlersEvent event) {
        PayloadRegistrar registrar = event.registrar("1");
        registrar.playToServer(ActiveSkillPayload.ID, ActiveSkillPayload.CODEC, (payload, context) -> {
            Player player = context.player();
            if (player.hasEffect(ModItems.TIEJI)) {
                player.displayClientMessage((Component)Component.translatable((String)"effect.tieji.tip").withStyle(ChatFormatting.RED), true);
                return;
            }
            LivingEntity entity = (LivingEntity)player.level().getEntity(payload.id());
            for (Skill skill : ModTools.getSkillsMayUse((LivingEntity)player)) {
                if (player == entity || !skill.activeSkill(player, skill, entity)) continue;
                return;
            }
            for (Skill skill : ModTools.getSkillsMayUse((LivingEntity)player)) {
                if (!skill.activeSkill(player, skill)) continue;
                return;
            }
        });
        registrar.playToServer(ShensuPayload.ID, ShensuPayload.CODEC, (p, c) -> {
            Player player = c.player();
            float speed = p.f();
            ItemStack stack = ModTools.trinketItem(SkillCards.SHENSU, (LivingEntity)player);
            if (!stack.isEmpty()) {
                CompoundTag nbt = ModTools.getOrCreateNbt(stack);
                nbt.putFloat("speed", speed);
                ModTools.setNbt(stack, nbt);
            }
        });
        registrar.playToServer(QuickSwapPayload.ID, QuickSwapPayload.CODEC, (pl, c) -> {
            Player target;
            Tuple<Tuple<DamageSource, Float>, ItemStack> pair;
            Player player = c.player();
            int i = pl.id();
            if (i == 0) {
                ModTools.openInv(player, player, player, (Component)Component.translatable((String)"key.dabaosword.select_card"), ItemStack.EMPTY, false, false, 3);
            }
            if (i == 2) {
                player.openMenu((MenuProvider)new SimpleMenuProvider((id, inv, player1) -> new PileScreenHandler(id, inv), (Component)Component.translatable((String)"card_pile.title")), buf -> buf.writeInt(0));
            }
            if (i == 3 && (pair = ModTools.getDamage(player)) != null) {
                ItemStack stack = ModTools.trinketItem(ModItems.CARD_PILE, (LivingEntity)player);
                CompoundTag nbt = ModTools.getOrCreateNbt(stack);
                nbt.remove("DamageDodged");
                ModTools.setNbt(stack, nbt);
                player.addEffect(new MobEffectInstance(ModItems.COOLDOWN2, 2, 0, false, false, false));
                player.hurt((DamageSource)((Tuple)pair.getA()).getA(), ((Float)((Tuple)pair.getA()).getB()).floatValue());
                ModTools.give((LivingEntity)player, (ItemStack)pair.getB(), new int[0]);
            }
            if (i == 9 && (target = ModTools.getClosestEntity((Entity)player, Player.class, 100.0, LivingEntity::isAlive)) != null) {
                ModTools.openFullInv(player, (LivingEntity)target, false);
            }
            if (i >= 100) {
                ModTools.replaceTrinketSlot(ModTools.trinketsWithSlots((LivingEntity)player, s -> s.is(Tags.SKILLS)), i - 100);
            }
        });
    }
}

