/*
 * Decompiled with CFR 0.152.
 */
package com.amotassic.dabaosword.pvpgame;

import com.amotassic.dabaosword.api.event.PVPGameTickEvent;
import com.amotassic.dabaosword.event.PVPGameEvents;
import com.amotassic.dabaosword.util.MODConfig;
import com.amotassic.dabaosword.util.ModTools;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.ServerScoreboard;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameType;
import net.minecraft.world.scores.Objective;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;

public class Game {
    private final ServerLevel world;
    private final int id;
    private final Set<UUID> players = new HashSet<UUID>();
    private final int type;
    private boolean active;
    private int countDown;
    private int gameTime;
    private int timeOut;
    public int zhongLives;
    public int fanLives;
    public int neiLives;
    public int zhongScore;
    public int fanScore;
    public int neiScore;
    private Map<String, Integer> primaryDataCache;
    public static final String FANCOUNT = "fanCount";
    public static final String NEICOUNT = "neiCount";
    public static final String ZHONGCOUNT = "zhongCount";
    public static final String ZHONGLIVES = "zhongLives";
    public static final String FANLIVES = "fanLives";
    public static final String NEILIVES = "neiLives";

    public Game(int id, ServerLevel world, Set<UUID> players, int type) {
        this.world = world;
        this.id = id;
        this.players.addAll(players);
        this.type = type;
        this.active = true;
        this.countDown = MODConfig.WaitTime * 20;
        this.gameTime = 0;
        this.timeOut = MODConfig.TimeOut;
        this.initData();
    }

    public Game(ServerLevel world, CompoundTag nbt) {
        this.world = world;
        this.id = nbt.getInt("Id");
        ListTag nbtList = nbt.getList("Players", 10);
        for (Tag nbtElement : nbtList) {
            this.players.add(NbtUtils.loadUUID((Tag)nbtElement));
        }
        this.type = nbt.getInt("Type");
        this.active = nbt.getBoolean("Active");
        this.countDown = nbt.getInt("CountDown");
        this.gameTime = nbt.getInt("GameTime");
        this.timeOut = nbt.getInt("TimeOut");
        this.zhongLives = nbt.getInt("ZhongLives");
        this.fanLives = nbt.getInt("FanLives");
        this.neiLives = nbt.getInt("NeiLives");
        this.zhongScore = nbt.getInt("ZhongScore");
        this.fanScore = nbt.getInt("FanScore");
        this.neiScore = nbt.getInt("NeiScore");
    }

    public Map<String, Integer> getPrimaryData() {
        int fanLives;
        int neiCount;
        if (this.primaryDataCache != null) {
            return this.primaryDataCache;
        }
        HashMap<String, Integer> data = new HashMap<String, Integer>();
        int playerCount = this.getPlayers().size();
        int fanCount = playerCount / 2;
        int n = neiCount = playerCount > 2 ? 1 : 0;
        if (this.type == 1 && playerCount % 2 == 0) {
            neiCount = 0;
        }
        int zhongCount = playerCount - fanCount - neiCount;
        int zhongLives = fanLives = fanCount * 3;
        int neiLives = neiCount > 0 ? fanCount * 3 : 0;
        data.put(FANCOUNT, fanCount);
        data.put(NEICOUNT, neiCount);
        data.put(ZHONGCOUNT, zhongCount);
        data.put(ZHONGLIVES, zhongLives);
        data.put(FANLIVES, fanLives);
        data.put(NEILIVES, neiLives);
        this.primaryDataCache = data;
        return data;
    }

    private void initData() {
        int i;
        Map<String, Integer> primaryData = this.getPrimaryData();
        ArrayList<String> ids = new ArrayList<String>();
        for (i = 0; i < primaryData.get(ZHONGCOUNT); ++i) {
            ids.add(Identity.ZHONG.tag);
        }
        for (i = 0; i < primaryData.get(FANCOUNT); ++i) {
            ids.add(Identity.FAN.tag);
        }
        for (i = 0; i < primaryData.get(NEICOUNT); ++i) {
            ids.add(Identity.NEI.tag);
        }
        Collections.shuffle(ids);
        this.forEachPlayer(player -> {
            player.getTags().remove("dabaosword.zhong");
            player.getTags().remove("dabaosword.fan");
            player.getTags().remove("dabaosword.nei");
            player.addTag((String)ids.removeFirst());
        });
        this.zhongLives = primaryData.get(ZHONGLIVES);
        this.fanLives = primaryData.get(FANLIVES);
        this.neiLives = primaryData.get(NEILIVES);
        this.neiScore = 0;
        this.fanScore = 0;
        this.zhongScore = 0;
    }

    public void writeNbt(CompoundTag nbt) {
        nbt.putInt("Id", this.id);
        ListTag nbtList = new ListTag();
        for (UUID uuid : this.players) {
            nbtList.add((Object)NbtUtils.createUUID((UUID)uuid));
        }
        nbt.put("Players", (Tag)nbtList);
        nbt.putInt("Type", this.type);
        nbt.putBoolean("Active", this.active);
        nbt.putInt("CountDown", this.countDown);
        nbt.putInt("GameTime", this.gameTime);
        nbt.putInt("TimeOut", this.timeOut);
        nbt.putInt("ZhongLives", this.zhongLives);
        nbt.putInt("FanLives", this.fanLives);
        nbt.putInt("NeiLives", this.neiLives);
        nbt.putInt("ZhongScore", this.zhongScore);
        nbt.putInt("FanScore", this.fanScore);
        nbt.putInt("NeiScore", this.neiScore);
    }

    public boolean isPlayerInThisGame(Player player) {
        return this.players.contains(player.getUUID());
    }

    public int getGameId() {
        return this.id;
    }

    public boolean isActive() {
        return this.active;
    }

    public Set<UUID> getPlayers() {
        return this.players;
    }

    public boolean isWaiting() {
        return this.countDown > 0;
    }

    public int getCountDown() {
        return this.countDown;
    }

    public int getGameTime() {
        return this.gameTime;
    }

    public int getTimeOut() {
        return this.timeOut;
    }

    public boolean isOn() {
        return this.getGameTime() > 0;
    }

    public void refuseGame(Player player) {
        if (!this.isWaiting()) {
            return;
        }
        this.discardGame();
        this.forEachPlayer(p -> {
            p.displayClientMessage((Component)Component.translatable((String)"dabaosword.game.refuse", (Object[])new Object[]{player.getDisplayName()}).withStyle(ChatFormatting.RED), false);
            ModTools.voice((LivingEntity)p, SoundEvents.SHIELD_BREAK, new float[0]);
        });
    }

    public void win(Identity identity) {
        this.forEachPlayer(player -> {
            if (this.getIdentity((ServerPlayer)player) == identity) {
                ModTools.voice((LivingEntity)player, "win", new float[0]);
                ModTools.title(player, (Component)Component.translatable((String)"dabaosword.game.win").withStyle(ChatFormatting.GOLD));
            }
            player.displayClientMessage((Component)Component.translatable((String)"dabaosword.game.end", (Object[])new Object[]{Component.translatable((String)identity.tag)}).withStyle(Game.getIdentityColor(identity)), false);
        });
        this.discardGame();
    }

    public void timeOut() {
        this.forEachPlayer(player -> player.displayClientMessage((Component)Component.translatable((String)"dabaosword.game.timeout").withStyle(ChatFormatting.RED), false));
        Integer max = Game.findUniqueMax(this.zhongScore, this.fanScore, this.neiScore);
        if (max == null) {
            this.discardGame();
        } else if (this.zhongScore == max) {
            this.win(Identity.ZHONG);
        } else if (this.fanScore == max) {
            this.win(Identity.FAN);
        } else if (this.neiScore == max) {
            this.win(Identity.NEI);
        }
    }

    public void discardGame() {
        this.active = false;
        ServerScoreboard scoreboard = this.world.getServer().getScoreboard();
        Objective obj = scoreboard.getObjectives().stream().filter(o -> o.getName().equals("dabaosword.death")).findFirst().orElse(null);
        if (obj != null && PVPGameEvents.getGameManager().getGameCount() <= 1) {
            scoreboard.removeObjective(obj);
        }
        this.forEachPlayer(player -> {
            player.getTags().remove("dabaosword.zhong");
            player.getTags().remove("dabaosword.fan");
            player.getTags().remove("dabaosword.nei");
            if (player.isSpectator()) {
                player.setGameMode(GameType.SURVIVAL);
                player.kill();
            }
        });
    }

    public void tick() {
        if (!this.active) {
            return;
        }
        NeoForge.EVENT_BUS.post((Event)new PVPGameTickEvent(this, this.world));
        if (this.countDown > -1) {
            --this.countDown;
        } else {
            ++this.gameTime;
        }
        if (this.isOn() && this.getGameTime() % 20 == 0) {
            --this.timeOut;
        }
    }

    public void forEachPlayer(Consumer<ServerPlayer> action) {
        for (UUID uuid : this.getPlayers()) {
            ServerPlayer player = this.world.getServer().getPlayerList().getPlayer(uuid);
            if (player == null) continue;
            action.accept(player);
        }
    }

    public int getRespawnChances(Identity identity) {
        Map<String, Integer> data = this.getPrimaryData();
        return switch (identity.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> this.zhongLives - data.get(ZHONGCOUNT) + 1;
            case 1 -> this.fanLives - data.get(FANCOUNT) + 1;
            case 2 -> this.neiLives - data.get(NEICOUNT) + 1;
        };
    }

    public int getLives(Identity identity) {
        return switch (identity.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> this.zhongLives;
            case 1 -> this.fanLives;
            case 2 -> this.neiLives;
        };
    }

    public void setLives(Identity identity, int lives) {
        switch (identity.ordinal()) {
            case 0: {
                this.zhongLives = lives;
                break;
            }
            case 1: {
                this.fanLives = lives;
                break;
            }
            case 2: {
                this.neiLives = lives;
            }
        }
    }

    public void decreaseLives(ServerPlayer player) {
        Identity identity = this.getIdentity(player);
        int lives = this.getLives(identity);
        if (lives > 0) {
            this.setLives(identity, lives - 1);
        }
    }

    public int getScore(Identity identity) {
        return switch (identity.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> this.zhongScore;
            case 1 -> this.fanScore;
            case 2 -> this.neiScore;
        };
    }

    public void setScore(Identity identity, int score) {
        switch (identity.ordinal()) {
            case 0: {
                this.zhongScore = score;
                break;
            }
            case 1: {
                this.fanScore = score;
                break;
            }
            case 2: {
                this.neiScore = score;
            }
        }
    }

    public void increaseScore(ServerPlayer player) {
        Identity identity = this.getIdentity(player);
        this.setScore(identity, this.getScore(identity) + 1);
        this.timeOut = MODConfig.TimeOut;
        this.forEachPlayer(p -> p.displayClientMessage((Component)Component.translatable((String)"dabaosword.score.add", (Object[])new Object[]{player.getDisplayName()}).withStyle(ChatFormatting.BOLD), false));
    }

    public Identity getIdentity(ServerPlayer player) {
        if (player.getTags().contains(Identity.ZHONG.tag)) {
            return Identity.ZHONG;
        }
        if (player.getTags().contains(Identity.FAN.tag)) {
            return Identity.FAN;
        }
        return Identity.NEI;
    }

    public static Integer findUniqueMax(int ... numbers) {
        if (numbers.length == 0) {
            return null;
        }
        int max = numbers[0];
        boolean isUnique = true;
        for (int i = 1; i < numbers.length; ++i) {
            if (numbers[i] > max) {
                max = numbers[i];
                isUnique = true;
                continue;
            }
            if (numbers[i] != max) continue;
            isUnique = false;
        }
        return isUnique ? Integer.valueOf(max) : null;
    }

    public static ChatFormatting getIdentityColor(Identity identity) {
        return switch (identity.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> ChatFormatting.YELLOW;
            case 1 -> ChatFormatting.GREEN;
            case 2 -> ChatFormatting.BLUE;
        };
    }

    public static enum Identity {
        ZHONG("dabaosword.zhong"),
        FAN("dabaosword.fan"),
        NEI("dabaosword.nei");

        public final String tag;

        private Identity(String tag) {
            this.tag = tag;
        }
    }
}

