/*
 * Decompiled with CFR 0.152.
 */
package com.amotassic.dabaosword.pvpgame;

import com.amotassic.dabaosword.event.PVPGameEvents;
import com.amotassic.dabaosword.pvpgame.Game;
import com.amotassic.dabaosword.util.MODConfig;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;

public class GameManager
extends SavedData {
    private final Map<Integer, Game> games = new HashMap<Integer, Game>();
    private final ServerLevel world;
    private int nextAvailableId;

    public static SavedData.Factory<GameManager> factory(ServerLevel world) {
        return new SavedData.Factory(() -> new GameManager(world), (nbt, r) -> GameManager.fromNbt(world, nbt), null);
    }

    public GameManager(ServerLevel world) {
        this.world = world;
        this.nextAvailableId = 1;
        this.setDirty();
    }

    public int getGameCount() {
        return this.games.size();
    }

    @Nullable
    public Game createGame(ServerPlayer player, int type) {
        AABB box = new AABB(player.getOnPos()).inflate((double)MODConfig.SearchRadius);
        List players = player.level().getEntitiesOfClass(Player.class, box, p -> !p.isSpectator() && !this.isPlayerInGame((Player)p));
        if (players.size() < 2) {
            player.displayClientMessage((Component)Component.literal((String)"Not enough players to start a game!").withStyle(ChatFormatting.RED), false);
            return null;
        }
        HashSet<UUID> playerUuids = new HashSet<UUID>();
        for (Player p2 : players) {
            playerUuids.add(p2.getUUID());
        }
        Game game = new Game(this.nextId(), this.world, playerUuids, type);
        PVPGameEvents.onGameCreate(player, game, playerUuids);
        this.games.put(game.getGameId(), game);
        this.setDirty();
        return game;
    }

    @Nullable
    public Game getGameByPlayer(Player player) {
        for (Game game : this.games.values()) {
            if (!game.isPlayerInThisGame(player)) continue;
            return game;
        }
        return null;
    }

    public boolean isPlayerInGame(Player player) {
        return this.getGameByPlayer(player) != null;
    }

    public void tick() {
        Iterator<Game> iterator = this.games.values().iterator();
        while (iterator.hasNext()) {
            Game game = iterator.next();
            if (!game.isActive()) {
                iterator.remove();
                this.setDirty();
                continue;
            }
            game.tick();
        }
        if (this.world.getGameTime() % 200L == 0L) {
            this.setDirty();
        }
    }

    public static GameManager fromNbt(ServerLevel world, CompoundTag nbt) {
        GameManager gameManager = new GameManager(world);
        gameManager.nextAvailableId = nbt.getInt("NextAvailableID");
        ListTag nbtList = nbt.getList("Games", 10);
        for (int i = 0; i < nbtList.size(); ++i) {
            CompoundTag nbtCompound = nbtList.getCompound(i);
            Game game = new Game(world, nbtCompound);
            gameManager.games.put(game.getGameId(), game);
        }
        return gameManager;
    }

    public CompoundTag save(CompoundTag nbt, HolderLookup.Provider provider) {
        nbt.putInt("NextAvailableID", this.nextAvailableId);
        ListTag nbtList = new ListTag();
        for (Game game : this.games.values()) {
            CompoundTag nbtCompound = new CompoundTag();
            game.writeNbt(nbtCompound);
            nbtList.add((Object)nbtCompound);
        }
        nbt.put("Games", (Tag)nbtList);
        return nbt;
    }

    private int nextId() {
        return ++this.nextAvailableId;
    }
}

