/*
 * Decompiled with CFR 0.152.
 */
package com.amotassic.dabaosword.ui;

import com.amotassic.dabaosword.ui.FullInvScreenHandler;
import java.util.Set;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;

public class FullInvHandledScreen
extends AbstractContainerScreen<FullInvScreenHandler> {
    private static final ResourceLocation TEXTURE = ResourceLocation.withDefaultNamespace((String)"textures/gui/container/generic_54.png");
    private final Set<Integer> slotsEnabled;
    private final int rows;
    private final boolean notSelf;
    private final int armorRow;

    public FullInvHandledScreen(FullInvScreenHandler handler, Inventory inventory, Component title) {
        super((AbstractContainerMenu)handler, inventory, title);
        this.slotsEnabled = handler.slotsEnabled;
        this.rows = handler.rows;
        this.notSelf = handler.notSelf;
        this.armorRow = handler.armorRow;
        int height = 38 + this.rows * 18;
        if (this.notSelf) {
            height += 76;
        }
        this.imageHeight = height;
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    protected void renderBg(GuiGraphics guiGraphics, float v0, int i0, int i1) {
        int x = this.leftPos;
        int y = this.topPos;
        guiGraphics.blit(TEXTURE, x, y, 0, 0, this.imageWidth, 17);
        for (int i = 0; i < this.rows * 2; ++i) {
            guiGraphics.blit(TEXTURE, x, y + 17 + i * 9, 0, 125, this.imageWidth, 9);
        }
        int v = this.notSelf ? 125 : 215;
        int height = this.notSelf ? 97 : 7;
        guiGraphics.blit(TEXTURE, x, y + this.rows * 18 + 17, 0, v, this.imageWidth, height);
        for (int i : this.slotsEnabled) {
            Slot slot = ((FullInvScreenHandler)this.menu).getSlot(i);
            guiGraphics.blit(TEXTURE, slot.x + x - 1, slot.y + y - 1, 7, 17, 18, 18);
        }
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        guiGraphics.drawString(this.font, this.title, this.titleLabelX, this.titleLabelY, 0x404040, false);
        if (this.notSelf) {
            guiGraphics.drawString(this.font, this.playerInventoryTitle, 8, 21 + this.rows * 18, 0x404040, false);
        }
        if (this.slotsEnabled.contains(41)) {
            guiGraphics.drawString(this.font, (Component)Component.translatable((String)"trinkets"), 8, 5 + this.armorRow * 18, 0x404040, false);
        }
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (this.minecraft != null && this.minecraft.gameMode != null && this.hoveredSlot != null && this.minecraft.player != null && keyCode == 261) {
            this.minecraft.gameMode.handleInventoryMouseClick(((FullInvScreenHandler)this.menu).containerId, this.hoveredSlot.index, 114, ClickType.THROW, (Player)this.minecraft.player);
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }
}

