/*
 * Decompiled with CFR 0.152.
 */
package com.amotassic.dabaosword.ui;

import com.amotassic.dabaosword.item.ModItems;
import com.amotassic.dabaosword.util.ModTools;
import com.mojang.datafixers.util.Pair;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.npc.InventoryCarrier;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.inventory.IDynamicStackHandler;

public class FullInvScreenHandler
extends AbstractContainerMenu {
    private final Container inventory = new SimpleContainer(86);
    private final LivingEntity target;
    private final boolean editable;
    public final Set<Integer> slotsEnabled;
    public final int rows;
    public final int armorRow;
    public final boolean notSelf;

    public FullInvScreenHandler(int syncId, Inventory inv, FriendlyByteBuf buf) {
        super(ModItems.FULL_INV_SCREEN_HANDLER, syncId);
        int y;
        int x;
        boolean enabled;
        int index;
        int j;
        int i;
        int[] keySlots;
        int[] keySlots0;
        this.target = (LivingEntity)inv.player.level().getEntity(buf.readInt());
        this.editable = buf.readBoolean();
        this.slotsEnabled = FullInvScreenHandler.setup(this.inventory, this.target, this.editable);
        this.notSelf = inv.player != this.target;
        int row = 2;
        int armor = 2;
        for (int i2 : keySlots0 = new int[]{9, 18, 27}) {
            if (!this.slotsEnabled.contains(i2)) continue;
            ++armor;
        }
        this.armorRow = armor;
        for (int i3 : keySlots = new int[]{9, 18, 27, 41, 50, 59, 68, 77}) {
            if (!this.slotsEnabled.contains(i3)) continue;
            ++row;
        }
        this.rows = row;
        for (i = 0; i < 4; ++i) {
            for (j = 0; j < 9; ++j) {
                index = j + i * 9;
                enabled = this.slotsEnabled.contains(index);
                x = enabled ? 8 + j * 18 : 114514;
                y = enabled ? 18 + i * 18 : 114514;
                this.addSlot(new Slot(this, this.inventory, index, x, y){

                    public boolean mayPlace(ItemStack stack) {
                        return enabled;
                    }
                });
            }
        }
        this.addSlot(new Slot(this, this.inventory, 36, 80, 18 * armor){

            public Pair<ResourceLocation, ResourceLocation> getNoItemIcon() {
                return Pair.of((Object)InventoryMenu.BLOCK_ATLAS, (Object)InventoryMenu.EMPTY_ARMOR_SLOT_HELMET);
            }
        });
        this.addSlot(new Slot(this, this.inventory, 37, 98, 18 * armor){

            public Pair<ResourceLocation, ResourceLocation> getNoItemIcon() {
                return Pair.of((Object)InventoryMenu.BLOCK_ATLAS, (Object)InventoryMenu.EMPTY_ARMOR_SLOT_CHESTPLATE);
            }
        });
        this.addSlot(new Slot(this, this.inventory, 38, 116, 18 * armor){

            public Pair<ResourceLocation, ResourceLocation> getNoItemIcon() {
                return Pair.of((Object)InventoryMenu.BLOCK_ATLAS, (Object)InventoryMenu.EMPTY_ARMOR_SLOT_LEGGINGS);
            }
        });
        this.addSlot(new Slot(this, this.inventory, 39, 134, 18 * armor){

            public Pair<ResourceLocation, ResourceLocation> getNoItemIcon() {
                return Pair.of((Object)InventoryMenu.BLOCK_ATLAS, (Object)InventoryMenu.EMPTY_ARMOR_SLOT_BOOTS);
            }
        });
        this.addSlot(new Slot(this, this.inventory, 40, 152, 18 * armor){

            public Pair<ResourceLocation, ResourceLocation> getNoItemIcon() {
                return Pair.of((Object)InventoryMenu.BLOCK_ATLAS, (Object)InventoryMenu.EMPTY_ARMOR_SLOT_SHIELD);
            }
        });
        for (i = 0; i < 5; ++i) {
            for (j = 0; j < 9; ++j) {
                index = 41 + j + i * 9;
                enabled = this.slotsEnabled.contains(index);
                x = enabled ? 8 + j * 18 : 114514;
                y = enabled ? (armor + 1 + i) * 18 : 114514;
                this.addSlot(new Slot(this, this.inventory, index, x, y){

                    public boolean mayPlace(ItemStack stack) {
                        return enabled;
                    }
                });
            }
        }
        if (this.notSelf) {
            this.addPlayerInventorySlots(inv, this.rows);
        }
    }

    private static Set<Integer> setup(Container inventory, LivingEntity target, boolean editable) {
        HashSet<Integer> set = new HashSet<Integer>();
        if (editable) {
            if (target instanceof Player) {
                Player player = (Player)target;
                NonNullList inv2 = player.getInventory().items;
                for (i = 0; i < inv2.size() && i <= 35; ++i) {
                    inventory.setItem(i, (ItemStack)inv2.get(i));
                    set.add(i);
                }
            } else if (target instanceof InventoryCarrier) {
                InventoryCarrier owner = (InventoryCarrier)target;
                NonNullList stacks = owner.getInventory().getItems();
                for (i = 0; i < stacks.size(); ++i) {
                    inventory.setItem(i + 1, (ItemStack)stacks.get(i));
                    set.add(i + 1);
                }
            }
        }
        int armorIndex = 0;
        for (ItemStack stack : target.getArmorSlots()) {
            inventory.setItem(39 - armorIndex, stack);
            set.add(39 - armorIndex);
            ++armorIndex;
        }
        if (!(target instanceof Player)) {
            inventory.setItem(0, target.getMainHandItem());
            set.add(0);
        }
        inventory.setItem(40, target.getOffhandItem());
        set.add(40);
        CuriosApi.getCuriosInventory((LivingEntity)target).ifPresent(inv -> {
            IItemHandlerModifiable curios = inv.getEquippedCurios();
            for (int i = 0; i < curios.getSlots() && i < 45; ++i) {
                inventory.setItem(41 + i, curios.getStackInSlot(i));
                set.add(41 + i);
            }
        });
        return set;
    }

    public void clicked(int slotId, int button, ClickType clickType, Player player) {
        if (this.editable) {
            if (button == 114 && !player.level().isClientSide) {
                this.getSlot(slotId).set(ItemStack.EMPTY);
                FullInvScreenHandler.saveInv(this.inventory, this.target);
                return;
            }
            super.clicked(slotId, button, clickType, player);
            FullInvScreenHandler.saveInv(this.inventory, this.target);
        }
    }

    public ItemStack quickMoveStack(Player player, int invSlot) {
        ItemStack newStack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(invSlot);
        if (slot.hasItem()) {
            ItemStack originalStack = slot.getItem();
            newStack = originalStack.copy();
            if (invSlot < this.inventory.getContainerSize() ? !this.moveItemStackTo(originalStack, this.inventory.getContainerSize(), this.slots.size(), true) : !this.moveItemStackTo(originalStack, 0, this.inventory.getContainerSize(), false)) {
                return ItemStack.EMPTY;
            }
            if (originalStack.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
        }
        return newStack;
    }

    public static void saveInv(Container from, LivingEntity to) {
        for (int i = 0; i < 86; ++i) {
            ItemStack stack = from.getItem(i);
            if (i == 0 && !(to instanceof Player)) {
                to.setItemInHand(InteractionHand.MAIN_HAND, stack);
            }
            if (to instanceof InventoryCarrier) {
                InventoryCarrier owner = (InventoryCarrier)to;
                int size = owner.getInventory().getContainerSize();
                if (i > 0 && i - 1 < size) {
                    owner.getInventory().setItem(i - 1, stack);
                }
            }
            if (i < 36 && to instanceof Player) {
                Player player = (Player)to;
                player.getInventory().setItem(i, stack);
            }
            if (i == 36) {
                to.setItemSlot(EquipmentSlot.HEAD, stack);
            }
            if (i == 37) {
                to.setItemSlot(EquipmentSlot.CHEST, stack);
            }
            if (i == 38) {
                to.setItemSlot(EquipmentSlot.LEGS, stack);
            }
            if (i == 39) {
                to.setItemSlot(EquipmentSlot.FEET, stack);
            }
            if (i == 40) {
                to.setItemInHand(InteractionHand.OFF_HAND, stack);
            }
            if (i < 41) continue;
            List<Tuple<IDynamicStackHandler, Integer>> pairs = ModTools.trinketsWithSlots(to);
            for (Tuple<IDynamicStackHandler, Integer> pair : pairs) {
                if (pairs.indexOf(pair) != i - 41) continue;
                ((IDynamicStackHandler)pair.getA()).setStackInSlot(((Integer)pair.getB()).intValue(), stack);
            }
        }
    }

    public boolean stillValid(Player player) {
        return true;
    }

    private void addPlayerInventorySlots(Inventory inventory, int rows) {
        int i;
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addSlot(new Slot((Container)inventory, j + i * 9 + 9, 8 + j * 18, 32 + 18 * (rows + i)));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.addSlot(new Slot((Container)inventory, i, 8 + i * 18, 36 + 18 * (rows + 3)));
        }
    }
}

