/*
 * Decompiled with CFR 0.152.
 */
package com.amotassic.dabaosword.ui;

import com.amotassic.dabaosword.api.CardEvents;
import com.amotassic.dabaosword.api.CardPileInventory;
import com.amotassic.dabaosword.event.PVPGameEvents;
import com.amotassic.dabaosword.item.ModItems;
import com.amotassic.dabaosword.util.ModTools;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class PileScreenHandler
extends AbstractContainerMenu {
    private final CardPileInventory inventory;

    public PileScreenHandler(int syncId, Inventory inv, RegistryFriendlyByteBuf buf) {
        this(syncId, inv);
    }

    public PileScreenHandler(int syncId, Inventory inv) {
        super(ModItems.PILE_SCREEN_HANDLER, syncId);
        int j;
        this.inventory = new CardPileInventory(inv.player);
        Player player = inv.player;
        if (player instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            PVPGameEvents.PLAYER_CARD_PACKS.put(sp, this.inventory);
        }
        this.inventory.startOpen(inv.player);
        for (j = 0; j < 4; ++j) {
            for (int k = 0; k < 9; ++k) {
                this.addSlot(new PileSlot(this.inventory, k + j * 9, 8 + k * 18, 18 + j * 18));
            }
        }
        for (j = 0; j < 3; ++j) {
            for (int k = 0; k < 9; ++k) {
                this.addSlot(new Slot((Container)inv, k + j * 9 + 9, 8 + k * 18, 103 + j * 18));
            }
        }
        for (j = 0; j < 9; ++j) {
            this.addSlot(new Slot((Container)inv, j, 8 + j * 18, 161));
        }
    }

    public void removed(@NotNull Player player) {
        super.removed(player);
        this.inventory.stopOpen(player);
    }

    public void clicked(int slotId, int button, ClickType clickType, Player player) {
        if (button == 114 && !player.level().isClientSide) {
            ItemStack pile = ModTools.trinketItem(ModItems.CARD_PILE, (LivingEntity)player);
            CompoundTag nbt = ModTools.getOrCreateNbt(pile);
            int dropped = nbt.getInt("DroppedCards");
            ItemStack stack = this.getSlot(slotId).getItem();
            if (ModTools.isCard(stack)) {
                CardEvents.cardDiscard((LivingEntity)player, ModTools.d().cards(stack, 1, new boolean[0]));
                if (dropped == 2) {
                    nbt.remove("DroppedCards");
                    ModTools.draw((LivingEntity)player, new int[0]);
                } else {
                    nbt.putInt("DroppedCards", dropped + 1);
                }
                ModTools.setNbt(pile, nbt);
            }
            return;
        }
        super.clicked(slotId, button, clickType, player);
    }

    @NotNull
    public ItemStack quickMoveStack(@NotNull Player player, int slot) {
        ItemStack itemStack = ItemStack.EMPTY;
        Slot slot2 = (Slot)this.slots.get(slot);
        if (slot2.hasItem()) {
            ItemStack itemStack2 = slot2.getItem();
            itemStack = itemStack2.copy();
            if (slot < 36 ? !this.moveItemStackTo(itemStack2, 36, this.slots.size(), true) : !this.moveItemStackTo(itemStack2, 0, 36, false)) {
                return ItemStack.EMPTY;
            }
            if (itemStack2.isEmpty()) {
                slot2.setByPlayer(ItemStack.EMPTY);
            } else {
                slot2.setChanged();
            }
        }
        return itemStack;
    }

    public boolean stillValid(@NotNull Player player) {
        return true;
    }

    private static class PileSlot
    extends Slot {
        public PileSlot(Container inventory, int index, int x, int y) {
            super(inventory, index, x, y);
        }

        public boolean mayPlace(@NotNull ItemStack stack) {
            return ModTools.isCard(stack);
        }
    }
}

