/*
 * Decompiled with CFR 0.152.
 */
package com.amotassic.dabaosword.ui;

import com.amotassic.dabaosword.api.skill.ISkill;
import com.amotassic.dabaosword.api.skill.Skill;
import com.amotassic.dabaosword.item.ModItems;
import com.amotassic.dabaosword.ui.PlayerInvScreenHandler;
import com.amotassic.dabaosword.util.ModTools;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.multiplayer.MultiPlayerGameMode;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class PlayerInvHandledScreen
extends AbstractContainerScreen<PlayerInvScreenHandler> {
    private static final ResourceLocation TEXTURE = ResourceLocation.withDefaultNamespace((String)"textures/gui/container/generic_54.png");
    private final int rows;

    public PlayerInvHandledScreen(PlayerInvScreenHandler handler, Inventory inventory, Component title) {
        super((AbstractContainerMenu)handler, inventory, title);
        this.rows = handler.rows;
        this.imageHeight = 24 + this.rows * 18;
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        ArrayList<Component> screenTips = new ArrayList<Component>();
        Skill skill = ModTools.s(this.eventStack());
        skill.item.addScreenTip(skill, screenTips);
        if (skill.stack.isEmpty()) {
            screenTips.clear();
            screenTips.add((Component)Component.translatable((String)"screen.dabaosword.select_card"));
        }
        if (!screenTips.isEmpty()) {
            for (Component text : screenTips) {
                int y = 2 + 10 * screenTips.indexOf(text);
                int textWidth = this.font.width((FormattedText)text);
                Objects.requireNonNull(this.font);
                guiGraphics.fill(1, y - 1, 1 + textWidth + 2, y + 9, -14671840);
                guiGraphics.drawString(this.font, text, 2, y, 0xE0E0E0, false);
            }
        }
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.renderBg(guiGraphics, partialTick, mouseX, mouseY);
    }

    protected void renderBg(GuiGraphics guiGraphics, float v, int i0, int i1) {
        int x = this.leftPos;
        int y = this.topPos;
        guiGraphics.blit(TEXTURE, x, y, 0, 0, this.imageWidth, 17);
        for (int i = 0; i < this.rows; ++i) {
            guiGraphics.blit(TEXTURE, x, y + 17 + i * 18, 0, 17, this.imageWidth, 18);
        }
        guiGraphics.blit(TEXTURE, x, y + this.rows * 18 + 17, 0, 215, this.imageWidth, 7);
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        guiGraphics.drawString(this.font, this.title, this.titleLabelX, this.titleLabelY, 0x404040, false);
        PoseStack matrices = guiGraphics.pose();
        matrices.pushPose();
        matrices.translate(0.0f, 0.0f, 400.0f);
        this.getClicks().forEach((i, clicks) -> {
            Slot slot = ((PlayerInvScreenHandler)this.menu).getSlot((int)i);
            guiGraphics.drawString(this.font, (Component)Component.literal((String)("" + clicks)).withStyle(ChatFormatting.RED), slot.x, slot.y + 6, 0x404040, false);
        });
        matrices.popPose();
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        boolean canClose;
        boolean ctrlZ;
        boolean ctrlA = keyCode == 65 && modifiers == 2;
        boolean bl = ctrlZ = keyCode == 90 && modifiers == 2;
        assert (this.minecraft != null);
        ItemStack stack = this.eventStack();
        MultiPlayerGameMode manager = this.minecraft.gameMode;
        LocalPlayer player = this.minecraft.player;
        if (manager != null && player != null) {
            if (ctrlA) {
                manager.handleInventoryMouseClick(((PlayerInvScreenHandler)this.menu).containerId, 0, 65, ClickType.PICKUP_ALL, (Player)player);
                return true;
            }
            if (ctrlZ) {
                manager.handleInventoryMouseClick(((PlayerInvScreenHandler)this.menu).containerId, 0, 90, ClickType.PICKUP_ALL, (Player)player);
                return true;
            }
        }
        boolean bl2 = canClose = !(stack.getItem() instanceof ISkill) || this.selectedCount() >= ModTools.s(stack).getMinSelect();
        if ((!canClose || stack.is((Item)ModItems.DISCARD) || stack.is((Item)ModItems.STEAL)) && (this.minecraft.options.keyInventory.matches(keyCode, scanCode) || keyCode == 256)) {
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double amount) {
        if (this.minecraft == null) {
            return false;
        }
        MultiPlayerGameMode manager = this.minecraft.gameMode;
        LocalPlayer player = this.minecraft.player;
        if (manager != null && this.hoveredSlot != null && player != null) {
            int id = this.hoveredSlot.index;
            if (amount == 1.0) {
                manager.handleInventoryMouseClick(((PlayerInvScreenHandler)this.menu).containerId, id, 0, ClickType.PICKUP, (Player)player);
            }
            if (amount == -1.0) {
                manager.handleInventoryMouseClick(((PlayerInvScreenHandler)this.menu).containerId, id, 1, ClickType.PICKUP, (Player)player);
            }
        }
        return super.mouseScrolled(mouseX, mouseY, scrollX, amount);
    }

    private ItemStack eventStack() {
        return ((PlayerInvScreenHandler)this.menu).getSlot(81).getItem();
    }

    private Map<Integer, Integer> getClicks() {
        String[] split;
        String str = ModTools.getOrCreateNbt(((PlayerInvScreenHandler)this.menu).getSlot(82).getItem()).getString("Clicks");
        HashMap<Integer, Integer> clicks = new HashMap<Integer, Integer>();
        if (str.isEmpty()) {
            return clicks;
        }
        if ((str = str.substring(1, str.length() - 1)).isEmpty()) {
            return clicks;
        }
        for (String s : split = str.split(", ")) {
            String[] split1 = s.split("=");
            clicks.put(Integer.parseInt(split1[0]), Integer.parseInt(split1[1]));
        }
        return clicks;
    }

    private int selectedCount() {
        return this.getClicks().values().stream().mapToInt(Integer::intValue).sum();
    }
}

