/*
 * Decompiled with CFR 0.152.
 */
package com.amotassic.dabaosword.ui;

import com.amotassic.dabaosword.api.CardEvents;
import com.amotassic.dabaosword.api.skill.ExData;
import com.amotassic.dabaosword.api.skill.Skill;
import com.amotassic.dabaosword.item.ModItems;
import com.amotassic.dabaosword.util.ModTools;
import com.amotassic.dabaosword.util.TempInventory;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class PlayerInvScreenHandler
extends AbstractContainerMenu {
    private final Player target;
    private final TempInventory inv;
    private final ItemStack stack;
    private final Skill skill;
    private final List<Integer> clicks = new ArrayList<Integer>();
    public final int rows;

    public PlayerInvScreenHandler(int syncId, Inventory inv, RegistryFriendlyByteBuf buf) {
        this(syncId, new TempInventory(inv.player, ModTools.paibei(new int[0]), List.of()), (Player)inv.player.level().getEntity(buf.readInt()), PlayerInvScreenHandler.stringToSet(buf.readUtf()));
    }

    private static Set<Integer> stringToSet(String str) {
        String trimmed = str.substring(1, str.length() - 1);
        String[] parts = trimmed.split(", ");
        HashSet<Integer> set = new HashSet<Integer>();
        for (String part : parts) {
            if (part.isEmpty()) continue;
            set.add(Integer.parseInt(part));
        }
        return set;
    }

    public PlayerInvScreenHandler(int syncId, TempInventory inventory, Player target, Set<Integer> rowsToShow) {
        super(ModItems.PLAYER_INV_SCREEN_HANDLER, syncId);
        this.target = target;
        this.inv = inventory;
        this.stack = this.inv.getItem(81);
        this.skill = ModTools.s(this.stack);
        this.rows = rowsToShow.size();
        int line = 0;
        for (int j = 0; j < 9; ++j) {
            int i;
            if (rowsToShow.contains(j)) {
                if (j == 0) {
                    for (i = 0; i < 4; ++i) {
                        this.addSlot(new Slot((Container)this.inv, i, 8 + i * 18, 18));
                    }
                    this.addSlot(new Slot(this, (Container)this.inv, 4, 80, 18){

                        public Pair<ResourceLocation, ResourceLocation> getNoItemIcon() {
                            return Pair.of((Object)InventoryMenu.BLOCK_ATLAS, (Object)InventoryMenu.EMPTY_ARMOR_SLOT_HELMET);
                        }
                    });
                    this.addSlot(new Slot(this, (Container)this.inv, 5, 98, 18){

                        public Pair<ResourceLocation, ResourceLocation> getNoItemIcon() {
                            return Pair.of((Object)InventoryMenu.BLOCK_ATLAS, (Object)InventoryMenu.EMPTY_ARMOR_SLOT_CHESTPLATE);
                        }
                    });
                    this.addSlot(new Slot(this, (Container)this.inv, 6, 116, 18){

                        public Pair<ResourceLocation, ResourceLocation> getNoItemIcon() {
                            return Pair.of((Object)InventoryMenu.BLOCK_ATLAS, (Object)InventoryMenu.EMPTY_ARMOR_SLOT_LEGGINGS);
                        }
                    });
                    this.addSlot(new Slot(this, (Container)this.inv, 7, 134, 18){

                        public Pair<ResourceLocation, ResourceLocation> getNoItemIcon() {
                            return Pair.of((Object)InventoryMenu.BLOCK_ATLAS, (Object)InventoryMenu.EMPTY_ARMOR_SLOT_BOOTS);
                        }
                    });
                    this.addSlot(new Slot(this, (Container)this.inv, 8, 152, 18){

                        public Pair<ResourceLocation, ResourceLocation> getNoItemIcon() {
                            return Pair.of((Object)InventoryMenu.BLOCK_ATLAS, (Object)InventoryMenu.EMPTY_ARMOR_SLOT_SHIELD);
                        }
                    });
                } else {
                    for (i = 0; i < 9; ++i) {
                        this.addSlot(new Slot((Container)this.inv, i + j * 9, 8 + i * 18, 18 + line * 18));
                    }
                }
                ++line;
                continue;
            }
            for (i = 0; i < 9; ++i) {
                this.addSlot(new Slot((Container)this.inv, i + j * 9, 114514, 114514));
            }
        }
        this.inv.setItem(82, ModTools.paibei(new int[0]));
        for (int i = 0; i < 2; ++i) {
            this.addSlot(new Slot((Container)this.inv, 81 + i, 114514, 114514));
        }
    }

    public void clicked(int index, int button, @NotNull ClickType action, @NotNull Player player) {
        if (index >= 0 && index < 81 && this.target != null) {
            ItemStack selected = this.getStack(index);
            if (button == 65 && this.maxSelect() >= 100) {
                this.forEachNonEmptySlot(s -> this.addClick(s.getContainerSlot(), 99));
            }
            if (button == 90) {
                this.forEachNonEmptySlot(s -> this.setClick(s.getContainerSlot(), 0));
            }
            if (!selected.isEmpty()) {
                this.skill.item.onSlotClick(this, player, this.skill, this.target, index, button, action);
            }
            this.writeClicks();
            if (this.stack.isEmpty()) {
                boolean right = action == ClickType.PICKUP && button == 1;
                ItemStack toReplace = right ? player.getMainHandItem() : player.getOffhandItem();
                ItemStack mainCopy = toReplace.copy();
                ItemStack copy = selected.copy();
                if (!selected.isEmpty() && !ItemStack.matches((ItemStack)toReplace, (ItemStack)selected)) {
                    toReplace.setCount(0);
                    selected.setCount(0);
                    if (index >= 45) {
                        ModTools.getCardPack(player).removeItemNoUpdate(index - 45);
                    }
                    player.setItemInHand(right ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND, copy);
                    ModTools.give((LivingEntity)player, mainCopy, new int[0]);
                }
                ModTools.closeGUI(player);
            }
            if (selected != ItemStack.EMPTY) {
                ExData exData;
                if (this.stack.is((Item)ModItems.STEAL)) {
                    MutableComponent message = Component.translatable((String)"dabaosword.steal", (Object[])new Object[]{player.getDisplayName(), this.target.getDisplayName(), selected.getDisplayName()});
                    player.displayClientMessage((Component)message, false);
                    this.target.displayClientMessage((Component)message, false);
                    if (ModTools.isCard(selected)) {
                        exData = ModTools.d().cards(selected, 1, index < 4);
                        CardEvents.cardMove((LivingEntity)this.target, exData, (LivingEntity)player);
                    } else {
                        ModTools.give((LivingEntity)player, selected.copyWithCount(1), new int[0]);
                        selected.shrink(1);
                    }
                    ModTools.closeGUI(player);
                }
                if (this.stack.is((Item)ModItems.DISCARD)) {
                    MutableComponent message = Component.translatable((String)"dabaosword.discard", (Object[])new Object[]{player.getDisplayName(), this.target.getDisplayName(), selected.getDisplayName()});
                    player.displayClientMessage((Component)message, false);
                    this.target.displayClientMessage((Component)message, false);
                    exData = ModTools.d().cards(selected, 1, index < 4);
                    CardEvents.cardDiscard((LivingEntity)this.target, exData);
                    ModTools.closeGUI(player);
                }
            }
        }
    }

    public void removed(@NotNull Player player) {
        this.skill.item.onGuiClose(this, player, this.skill, this.target);
    }

    public ItemStack getStack(int slot) {
        LivingEntity livingEntity;
        if (slot < 0 || slot > 80) {
            return ItemStack.EMPTY;
        }
        ItemStack item = this.inv.getItem(slot);
        if (this.inv.type == 1 && item.is(ModItems.GAIN_CARD) && (livingEntity = this.inv.owner) instanceof Player) {
            Player pl = (Player)livingEntity;
            if (slot < 45) {
                return (ItemStack)pl.getInventory().items.get(slot - 9);
            }
            return (ItemStack)ModTools.getCardPack((Player)pl).cards.get(slot - 45);
        }
        return item;
    }

    @NotNull
    public ItemStack quickMoveStack(@NotNull Player player, int i) {
        return ItemStack.EMPTY;
    }

    public boolean stillValid(Player player) {
        MobEffectInstance effect = player.getEffect(ModItems.COOLDOWN2);
        return effect == null || effect.getAmplifier() != 2;
    }

    public void forEachNonEmptySlot(Consumer<Slot> action) {
        for (int i = 0; i < 81; ++i) {
            Slot slot = this.getSlot(i);
            if (!slot.hasItem()) continue;
            action.accept(slot);
        }
    }

    private void writeClicks() {
        ItemStack cinfo = this.getSlot(82).getItem();
        CompoundTag nbt = new CompoundTag();
        nbt.putString("Clicks", this.getClickMap().toString());
        ModTools.setNbt(cinfo, nbt);
    }

    public int maxSelect() {
        return this.skill.getMaxSelect();
    }

    private int getSlotClicked(int slot) {
        if (!this.clicks.contains(slot)) {
            return 0;
        }
        return this.getClickMap().get(slot);
    }

    public void addClick(int slot, int ... count) {
        int num = count.length > 0 ? count[0] : 1;
        int n = this.getSlot(slot).getItem().getCount();
        num = Math.min(n - this.getSlotClicked(slot), num);
        for (int i = 0; i < num; ++i) {
            this.clicks.add(slot);
            if (this.getSelectedCount() <= this.maxSelect()) continue;
            this.dropFirst(new int[0]);
        }
    }

    public void dropClick(int slot, int ... count) {
        if (!this.clicks.contains(slot)) {
            return;
        }
        int num = count.length > 0 ? count[0] : 1;
        for (int i = 0; i < num && this.clicks.remove((Object)slot); ++i) {
        }
    }

    public void setClick(int slot, int count) {
        if (this.clicks.contains(slot)) {
            this.dropClick(slot, 114514);
        }
        if (count > 0) {
            this.addClick(slot, count);
        }
    }

    public void dropFirst(int ... count) {
        if (this.clicks.isEmpty()) {
            return;
        }
        this.dropClick(this.clicks.getFirst(), count);
    }

    public int getSelectedCount() {
        return this.clicks.size();
    }

    public List<ItemStack> getSelected() {
        ArrayList<ItemStack> selected = new ArrayList<ItemStack>();
        this.clicks.forEach(slot -> {
            ItemStack stack = this.getSlot((int)slot).getItem();
            if (!stack.isEmpty()) {
                selected.add(stack.copyWithCount(1));
            }
        });
        return selected;
    }

    public Map<Integer, Integer> getClickMap() {
        HashMap<Integer, Integer> map = new HashMap<Integer, Integer>();
        for (Integer num : this.clicks) {
            if (map.containsKey(num)) {
                map.put(num, (Integer)map.get(num) + 1);
                continue;
            }
            map.put(num, 1);
        }
        return map;
    }

    public ExData toExData() {
        ExData exData = ModTools.d();
        Map<Integer, Integer> clickMap = this.getClickMap();
        clickMap.forEach((slot, count) -> {
            ItemStack stack = this.getStack((int)slot);
            if (ModTools.isCard(stack)) {
                exData.cards(stack, (int)count, slot < 4);
            }
        });
        return exData;
    }
}

