/*
 * Decompiled with CFR 0.152.
 */
package com.amotassic.dabaosword.util;

import com.amotassic.dabaosword.DabaoSword;
import com.amotassic.dabaosword.api.CardPileInventory;
import com.amotassic.dabaosword.api.card.Card;
import com.amotassic.dabaosword.api.card.Suit;
import com.amotassic.dabaosword.api.skill.ExData;
import com.amotassic.dabaosword.api.skill.ISkill;
import com.amotassic.dabaosword.api.skill.Skill;
import com.amotassic.dabaosword.api.skill.SkillExecutor;
import com.amotassic.dabaosword.api.skill.Trigger;
import com.amotassic.dabaosword.data.CardSuitAndRank;
import com.amotassic.dabaosword.event.PVPGameEvents;
import com.amotassic.dabaosword.item.ModItems;
import com.amotassic.dabaosword.item.card.CardItem;
import com.amotassic.dabaosword.item.card.Sha;
import com.amotassic.dabaosword.item.skillcard.SkillItem;
import com.amotassic.dabaosword.ui.FullInvScreenHandler;
import com.amotassic.dabaosword.ui.PlayerInvScreenHandler;
import com.amotassic.dabaosword.util.TempInventory;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.ParseResults;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import io.netty.buffer.Unpooled;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectListIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetSubtitleTextPacket;
import net.minecraft.network.protocol.game.ClientboundSetTitleTextPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Tuple;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotResult;
import top.theillusivec4.curios.api.type.inventory.IDynamicStackHandler;

public class ModTools {
    public static final Predicate<ItemStack> canSaveDying = ModTools.p(ModItems.JIU).or(ModTools.p(ModItems.PEACH));
    public static final Predicate<ItemStack> isSha = s -> s.getItem() instanceof Sha;
    public static final Predicate<ItemStack> isCard = ModTools::isCard;
    public static final Predicate<ItemStack> isBasic = s -> ModTools.c((ItemStack)s).type == 0;
    public static final Predicate<ItemStack> isArmoury = s -> ModTools.c((ItemStack)s).type == 1;
    public static final Predicate<ItemStack> isEquipment = s -> ModTools.c((ItemStack)s).type == 2;
    public static final Predicate<ItemStack> isDiamondCard = s -> ModTools.c((ItemStack)s).suit == Suit.Diamond;
    public static final Predicate<ItemStack> isHeartCard = s -> ModTools.c((ItemStack)s).suit == Suit.Heart;
    public static final Predicate<ItemStack> isClubCard = s -> ModTools.c((ItemStack)s).suit == Suit.Club;
    public static final Predicate<ItemStack> isSpadeCard = s -> ModTools.c((ItemStack)s).suit == Suit.Spade;
    public static final Predicate<ItemStack> isRedCard = isDiamondCard.or(isHeartCard);
    public static final Predicate<ItemStack> isBlackCard = isClubCard.or(isSpadeCard);
    private static final List<ItemStack> CARD_PILE = new ArrayList<ItemStack>();

    public static Card c(ItemStack card) {
        return new Card(card);
    }

    public static Card c(ItemStack card, CardItem replace) {
        Card c = ModTools.c(card);
        return new Card(replace, c.suit, c.rank);
    }

    public static Skill s(ItemStack skill) {
        return new Skill(skill);
    }

    public static ExData d() {
        return new ExData();
    }

    public static Predicate<ItemStack> p(Item item) {
        return s -> s.is(item);
    }

    public static boolean isCard(ItemStack s) {
        return s.getItem() instanceof CardItem;
    }

    @SafeVarargs
    public static <T> List<T> toList(T ... t) {
        return new ArrayList<T>(Arrays.asList(t));
    }

    public static boolean hasTrinket(Item item, LivingEntity entity) {
        return ModTools.isEquipped(entity, ModTools.p(item));
    }

    public static boolean isEquipped(LivingEntity entity, Predicate<ItemStack> p) {
        return CuriosApi.getCuriosInventory((LivingEntity)entity).map(c -> c.isEquipped(p)).orElse(false);
    }

    public static ItemStack trinketItem(Item item, LivingEntity entity) {
        return CuriosApi.getCuriosInventory((LivingEntity)entity).map(h -> h.findFirstCurio(item).map(SlotResult::stack).orElse(ItemStack.EMPTY)).orElse(ItemStack.EMPTY);
    }

    public static List<ItemStack> allTrinkets(LivingEntity entity) {
        return CuriosApi.getCuriosInventory((LivingEntity)entity).map(h -> h.findCurios(s -> true).stream().map(SlotResult::stack).toList()).orElse(Collections.emptyList());
    }

    public static List<Tuple<IDynamicStackHandler, Integer>> trinketsWithSlots(LivingEntity entity) {
        return ModTools.trinketsWithSlots(entity, s -> true);
    }

    public static List<Tuple<IDynamicStackHandler, Integer>> trinketsWithSlots(LivingEntity entity, Predicate<ItemStack> filter) {
        ArrayList<Tuple<IDynamicStackHandler, Integer>> pairs = new ArrayList<Tuple<IDynamicStackHandler, Integer>>();
        CuriosApi.getCuriosInventory((LivingEntity)entity).ifPresent(c -> c.getCurios().values().forEach(group -> {
            for (int i = 0; i < group.getSlots(); ++i) {
                if (!filter.test(group.getStacks().getStackInSlot(i))) continue;
                pairs.add(new Tuple((Object)group.getStacks(), (Object)i));
            }
        }));
        return pairs;
    }

    public static void replaceTrinketSlot(List<Tuple<IDynamicStackHandler, Integer>> pairs, int slot) {
        int i;
        if (slot < 1 || slot >= pairs.size()) {
            return;
        }
        ArrayList<ItemStack> copys = new ArrayList<ItemStack>(pairs.stream().map(p -> ((IDynamicStackHandler)p.getA()).getStackInSlot(((Integer)p.getB()).intValue()).copy()).toList());
        ItemStack stack = ((ItemStack)copys.get(slot)).copy();
        for (i = slot; i > 0; --i) {
            copys.set(i, (ItemStack)copys.get(i - 1));
        }
        copys.set(0, stack);
        for (i = 0; i < pairs.size(); ++i) {
            ((IDynamicStackHandler)pairs.get(i).getA()).setStackInSlot(((Integer)pairs.get(i).getB()).intValue(), (ItemStack)copys.get(i));
        }
    }

    public static CardPileInventory getCardPack(Player player) {
        if (player instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            return PVPGameEvents.PLAYER_CARD_PACKS.getOrDefault(sp, new CardPileInventory(player));
        }
        return new CardPileInventory(player);
    }

    public static boolean shouldReachLong(LivingEntity entity) {
        for (InteractionHand hand : InteractionHand.values()) {
            CardItem c;
            Item item = entity.getItemInHand(hand).getItem();
            if (!(item instanceof CardItem) || !(c = (CardItem)item).rangedUse()) continue;
            return true;
        }
        return false;
    }

    public static boolean hasCard(LivingEntity entity, Predicate<ItemStack> predicate) {
        return !ModTools.getCard(entity, predicate).isEmpty();
    }

    public static ItemStack getCard(LivingEntity entity, Predicate<ItemStack> predicate) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            for (ItemStack card : ModTools.getCardPack((Player)player).cards) {
                if (!predicate.test(card)) continue;
                return card;
            }
        }
        return ModTools.getItem(entity, predicate);
    }

    public static boolean hasItem(@NotNull LivingEntity entity, Predicate<ItemStack> predicate) {
        return !ModTools.getItem(entity, predicate).isEmpty();
    }

    public static ItemStack getItem(@NotNull LivingEntity entity, Predicate<ItemStack> predicate) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            for (ItemStack stack : player.getInventory().items) {
                if (!predicate.test(stack)) continue;
                return stack;
            }
        } else if (predicate.test(entity.getMainHandItem())) {
            return entity.getMainHandItem();
        }
        if (predicate.test(entity.getOffhandItem())) {
            return entity.getOffhandItem();
        }
        return ItemStack.EMPTY;
    }

    public static void voice(LivingEntity entity, SoundEvent sound, float ... volume) {
        Level level = entity.level();
        if (level instanceof ServerLevel) {
            ServerLevel world = (ServerLevel)level;
            float v = volume.length > 0 ? volume[0] : 2.0f;
            world.playSeededSound(null, (Entity)entity, Holder.direct((Object)sound), SoundSource.PLAYERS, v, 1.0f, entity.getRandom().nextLong());
        }
    }

    public static void voice(LivingEntity entity, Item item, float ... volume) {
        ModTools.voice(entity, BuiltInRegistries.ITEM.getKey((Object)item).getPath(), volume);
    }

    public static void voice(LivingEntity entity, ItemStack stack, float ... volume) {
        ModTools.voice(entity, stack.getItem(), volume);
    }

    public static void voice(LivingEntity entity, String name, float ... volume) {
        ModTools.voice(entity, ModTools.getSound("dabaosword", name), volume);
    }

    public static SoundEvent getSound(String namespace, String path) {
        return (SoundEvent)Holder.direct((Object)SoundEvent.createVariableRangeEvent((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)namespace, (String)path))).value();
    }

    public static int countCards(LivingEntity entity) {
        return ModTools.countCard(entity, isCard);
    }

    public static int countAllCards(LivingEntity entity) {
        return ModTools.count(entity, isCard, false, true, true);
    }

    public static int countCard(LivingEntity entity, Predicate<ItemStack> predicate) {
        return ModTools.count(entity, predicate, false, true, false);
    }

    public static int count(LivingEntity entity, Predicate<ItemStack> predicate, boolean armor, boolean pile, boolean trinkets) {
        int n = 0;
        for (ItemStack stack : ModTools.getItems(entity, predicate, true, armor, trinkets, pile)) {
            n += stack.getCount();
        }
        return n;
    }

    public static List<ItemStack> getItems(LivingEntity entity, Predicate<ItemStack> p, boolean main, boolean armor, boolean trinket, boolean pile) {
        Player player;
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        if (pile && entity instanceof Player) {
            player = (Player)entity;
            for (ItemStack stack : ModTools.getCardPack((Player)player).cards) {
                if (!p.test(stack)) continue;
                items.add(stack);
            }
        }
        if (main) {
            if (entity instanceof Player) {
                player = (Player)entity;
                for (ItemStack stack : player.getInventory().items) {
                    if (!p.test(stack)) continue;
                    items.add(stack);
                }
            } else if (p.test(entity.getMainHandItem())) {
                items.add(entity.getMainHandItem());
            }
            if (p.test(entity.getOffhandItem())) {
                items.add(entity.getOffhandItem());
            }
        }
        if (armor) {
            for (ItemStack stack : entity.getArmorSlots()) {
                if (!p.test(stack)) continue;
                items.add(stack);
            }
        }
        if (trinket) {
            for (ItemStack stack : ModTools.allTrinkets(entity)) {
                if (!p.test(stack)) continue;
                items.add(stack);
            }
        }
        return items;
    }

    public static void draw(LivingEntity entity, int ... count) {
        int num = count.length > 0 ? count[0] : 1;
        for (int n = 0; n < num; ++n) {
            if (entity.hasEffect(ModItems.BINGLIANG)) {
                int amplifier = Objects.requireNonNull(entity.getEffect(ModItems.BINGLIANG)).getAmplifier();
                entity.removeEffect(ModItems.BINGLIANG);
                ModTools.voice(entity, SoundEvents.VILLAGER_NO, 1.0f);
                if (amplifier == 0) continue;
                entity.addEffect(new MobEffectInstance(ModItems.BINGLIANG, -1, amplifier - 1));
                continue;
            }
            ModTools.give(entity, ModTools.newCard(), new int[0]);
            ModTools.voice(entity, SoundEvents.EXPERIENCE_ORB_PICKUP, 1.0f);
        }
    }

    public static ItemStack customLoot(LivingEntity entity, String path) {
        LootParams set;
        LootTable lt = Objects.requireNonNull(entity.level().getServer()).reloadableRegistries().getLootTable(ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"dabaosword", (String)path)));
        ObjectArrayList list = lt.getRandomItems(set = new LootParams.Builder((ServerLevel)entity.level()).withParameter(LootContextParams.ORIGIN, (Object)entity.position()).withParameter(LootContextParams.THIS_ENTITY, (Object)entity).create(LootContextParamSets.GIFT));
        ObjectListIterator objectListIterator = list.iterator();
        if (objectListIterator.hasNext()) {
            ItemStack stack = (ItemStack)objectListIterator.next();
            return stack;
        }
        return ItemStack.EMPTY;
    }

    public static ItemStack newCard() {
        if (CARD_PILE.isEmpty()) {
            for (ItemStack stack : CardSuitAndRank.ALL_CARDS) {
                CARD_PILE.add(stack.copy());
            }
            Collections.shuffle(CARD_PILE);
            DabaoSword.LOGGER.info("Shuffled card pile");
        }
        return CARD_PILE.removeFirst();
    }

    public static ItemStack newCard(Item item) {
        return ModTools.newCard(ModTools.p(item));
    }

    public static ItemStack newCard(Predicate<ItemStack> predicate) {
        List<ItemStack> list = CardSuitAndRank.ALL_CARDS.stream().filter(predicate).toList();
        if (list.isEmpty()) {
            return ItemStack.EMPTY;
        }
        return list.get(new Random().nextInt(list.size())).copy();
    }

    public static void give(LivingEntity entity, ItemStack stack, int ... pickupDelay) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            ItemEntity item = player.drop(stack, false);
            if (item == null) {
                return;
            }
            item.setInvulnerable(true);
            int delay = pickupDelay.length > 0 ? pickupDelay[0] : 0;
            item.setPickUpDelay(delay);
            item.setTarget(player.getUUID());
            item.addTag("follow_owner");
            return;
        }
        if (entity.getMainHandItem().isEmpty()) {
            entity.setItemInHand(InteractionHand.MAIN_HAND, stack);
        } else if (entity.getOffhandItem().isEmpty()) {
            entity.setItemInHand(InteractionHand.OFF_HAND, stack);
        }
    }

    @Nullable
    public static <T extends Entity> T getClosestEntity(Entity entity, Class<T> clazz, double boxLength, Predicate<T> predicate) {
        AABB box;
        ServerLevel world;
        List entities;
        Level level = entity.level();
        if (level instanceof ServerLevel && !(entities = (world = (ServerLevel)level).getEntitiesOfClass(clazz, box = new AABB(entity.getOnPos()).inflate(boxLength), predicate.and(e -> e != entity))).isEmpty()) {
            HashMap<Float, Entity> map = new HashMap<Float, Entity>();
            for (Entity e2 : entities) {
                map.put(Float.valueOf(e2.distanceTo(entity)), e2);
            }
            float min = ((Float)Collections.min(map.keySet())).floatValue();
            return (T)((Entity)map.get(Float.valueOf(min)));
        }
        return null;
    }

    public static CompoundTag getOrCreateNbt(ItemStack stack) {
        if (stack.isEmpty()) {
            return new CompoundTag();
        }
        CustomData component = (CustomData)stack.get(DataComponents.CUSTOM_DATA);
        if (component == null) {
            return new CompoundTag();
        }
        return component.copyTag();
    }

    public static void setNbt(ItemStack stack, CompoundTag nbt) {
        stack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)nbt));
    }

    public static void openFullInv(Player player, LivingEntity target, boolean editable) {
        if (player.level().isClientSide) {
            return;
        }
        FriendlyByteBuf b = new FriendlyByteBuf(Unpooled.buffer());
        b.writeInt(target.getId());
        b.writeBoolean(editable);
        player.openMenu((MenuProvider)new SimpleMenuProvider((i, inv, player1) -> new FullInvScreenHandler(i, inv, b), target.getName()), buf -> {
            buf.writeInt(target.getId());
            buf.writeBoolean(editable);
        });
    }

    public static void openInv(Player player, Player owner, Player target, Component title, ItemStack stack, boolean equip, boolean armor, int cards) {
        if (player.level().isClientSide) {
            return;
        }
        TempInventory tempInv = new TempInventory(player, (LivingEntity)owner, stack, cards, equip, armor);
        Set<Integer> rows = tempInv.rowsToShow;
        player.openMenu((MenuProvider)new SimpleMenuProvider((i, inv, player1) -> new PlayerInvScreenHandler(i, tempInv, target, rows), title), buf -> {
            buf.writeInt(target.getId());
            buf.writeUtf(rows.toString());
        });
    }

    public static void openMenu(Player player, Player target, ItemStack stack, List<ItemStack> stacks, Component title) {
        if (player.level().isClientSide) {
            return;
        }
        TempInventory tempInv = new TempInventory(player, stack, stacks);
        Set<Integer> rows = tempInv.rowsToShow;
        player.openMenu((MenuProvider)new SimpleMenuProvider((i, inv, player1) -> new PlayerInvScreenHandler(i, tempInv, target, rows), title), buf -> {
            buf.writeInt(target.getId());
            buf.writeUtf(rows.toString());
        });
    }

    public static ItemStack paibei(int ... n) {
        return new ItemStack((ItemLike)ModItems.GAIN_CARD, n.length > 0 ? n[0] : 1);
    }

    public static void closeGUI(Player player) {
        player.addEffect(new MobEffectInstance(ModItems.COOLDOWN2, 1, 2, false, false, false));
    }

    public static Holder<Enchantment> getEntry(ResourceKey<Enchantment> key, Entity ... entity) {
        Entity e = entity.length > 0 ? entity[0] : null;
        Registry enchantments = e == null ? DabaoSword.server.registryAccess().registryOrThrow(Registries.ENCHANTMENT) : e.registryAccess().registryOrThrow(Registries.ENCHANTMENT);
        return enchantments.getHolder(key).orElse(null);
    }

    public static DamageSource getDamageSource(Entity source, ResourceKey<DamageType> type) {
        return new DamageSource((Holder)source.level().registryAccess().registryOrThrow(Registries.DAMAGE_TYPE).getHolderOrThrow(type), source);
    }

    public static void writeDamage(DamageSource source, float amount, boolean returnShan, ItemStack stack) {
        ListTag list = new ListTag();
        CompoundTag compound = new CompoundTag();
        compound.putString("type", ((ResourceKey)source.typeHolder().unwrapKey().get()).location().toString());
        if (source.getDirectEntity() != null) {
            compound.putInt("source", source.getDirectEntity().getId());
        }
        if (source.getEntity() != null) {
            compound.putInt("attacker", source.getEntity().getId());
        }
        compound.putFloat("amount", amount);
        if (returnShan) {
            compound.putString("returning", "dabaosword:shan");
        }
        list.add((Object)compound);
        CompoundTag nbt = ModTools.getOrCreateNbt(stack);
        nbt.put("DamageDodged", (Tag)list);
        ModTools.setNbt(stack, nbt);
    }

    public static Tuple<Tuple<DamageSource, Float>, ItemStack> getDamage(Player player) {
        Level level = player.level();
        if (level instanceof ServerLevel) {
            ServerLevel world = (ServerLevel)level;
            ItemStack stack = ModTools.trinketItem(ModItems.CARD_PILE, (LivingEntity)player);
            CompoundTag compound = ModTools.getOrCreateNbt(stack);
            if (compound.contains("DamageDodged")) {
                CompoundTag nbt = ((ListTag)Objects.requireNonNull(compound.get("DamageDodged"))).getCompound(0);
                ResourceKey type = ResourceKey.create((ResourceKey)Registries.DAMAGE_TYPE, (ResourceLocation)ResourceLocation.parse((String)nbt.getString("type")));
                Holder.Reference entry = world.registryAccess().registryOrThrow(Registries.DAMAGE_TYPE).getHolderOrThrow(type);
                Entity source = world.getEntity(nbt.getInt("source"));
                Entity attacker = world.getEntity(nbt.getInt("attacker"));
                DamageSource damageSource = new DamageSource((Holder)entry, source, attacker);
                ItemStack returning = ItemStack.EMPTY;
                if (nbt.contains("returning")) {
                    returning = new ItemStack((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)nbt.getString("returning"))));
                }
                float amount = nbt.getFloat("amount");
                return new Tuple((Object)new Tuple((Object)damageSource, (Object)Float.valueOf(amount)), (Object)returning);
            }
        }
        return null;
    }

    public static void excuteServerCommand(Entity entity, String ... commands) {
        Level level = entity.level();
        if (level instanceof ServerLevel) {
            ServerLevel world = (ServerLevel)level;
            MinecraftServer server = world.getServer();
            CommandDispatcher dispatcher = server.getCommands().getDispatcher();
            CommandSourceStack commandSource = entity.createCommandSourceStack().withPermission(2).withSuppressedOutput();
            for (String command : commands) {
                if (command.startsWith("/")) {
                    command = command.substring(1);
                }
                try {
                    ParseResults results = dispatcher.parse(command, (Object)commandSource);
                    dispatcher.execute(results);
                }
                catch (CommandSyntaxException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    public static void title(ServerPlayer player, Component title) {
        player.connection.send((Packet)new ClientboundSetTitleTextPacket(title));
    }

    public static void subtitle(ServerPlayer player, Component sub) {
        player.connection.send((Packet)new ClientboundSetSubtitleTextPacket(sub));
    }

    public static List<LivingEntity> getSkillOwners(LivingEntity entity) {
        if (entity.level().isClientSide) {
            return List.of();
        }
        return new ArrayList<LivingEntity>(Objects.requireNonNull(entity.getServer()).getPlayerList().getPlayers());
    }

    public static List<Skill> getSkillsMayUse(LivingEntity entity) {
        Predicate<ItemStack> p = s -> {
            if (!(s.getItem() instanceof ISkill)) {
                return false;
            }
            if (s.getItem() instanceof SkillItem && entity.getTags().contains("duanchang")) {
                return false;
            }
            return ModTools.s(s).lockOn() || !entity.hasEffect(ModItems.TIEJI);
        };
        return CuriosApi.getCuriosInventory((LivingEntity)entity).map(c -> c.findCurios(p).stream().map(SlotResult::stack).map(Skill::new).toList()).orElse(Collections.emptyList());
    }

    public static int getResult(Trigger t, LivingEntity owner, LivingEntity triggered, ExData exData) {
        for (Skill skill : ModTools.getSkillsMayUse(owner)) {
            for (SkillExecutor data : skill.data()) {
                int i;
                if (!List.of(data.trigger()).contains((Object)t) || !data.relation().test(owner, triggered, exData.source) || (i = data.apply(owner, triggered, skill, exData)) <= 0) continue;
                return i;
            }
        }
        return 0;
    }

    public static String getTagValue(Entity entity, String name) {
        return entity.getTags().stream().filter(s -> s.startsWith(name + "_")).findFirst().map(s -> s.split("_")[1]).orElse("");
    }

    public static int getTagCount(Entity entity, String name) {
        return entity.getTags().stream().filter(s -> s.startsWith(name + "_")).findFirst().map(s -> Integer.parseInt(s.split("_")[1])).orElse(0);
    }

    public static boolean hasTag(Entity entity, String name) {
        return entity.getTags().stream().anyMatch(s -> s.startsWith(name));
    }

    public static void removeTag(Entity entity, String name) {
        Iterator each = entity.getTags().iterator();
        while (each.hasNext()) {
            if (!((String)each.next()).startsWith(name)) continue;
            each.remove();
            break;
        }
    }

    public static void addTag(Entity entity, String name, int n) {
        ModTools.removeTag(entity, name);
        entity.addTag(name + "_" + n);
    }

    public static void addTag(Entity entity, String name, String suffix) {
        entity.addTag(name + "_" + suffix);
    }
}

