package com.amotassic.dabaosword.api;

import com.amotassic.dabaosword.api.skill.ExData;
import com.amotassic.dabaosword.api.skill.Skill;
import com.amotassic.dabaosword.api.skill.SkillExecutor;
import com.amotassic.dabaosword.api.skill.Trigger;
import com.amotassic.dabaosword.item.ModItems;
import com.amotassic.dabaosword.item.card.equipment.Equipment;
import java.util.List;
import net.minecraft.class_1268;
import net.minecraft.class_1282;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;

import static com.amotassic.dabaosword.util.ModTools.*;

public class CardEvents {

    /**
     * 装备牌被弃置前触发的事件，可以理解为装备牌的“亡语”，典型比如白银狮子回血效果。
     * 由于我设计的是卡牌被清除后才会触发技能效果，如果被清除的装备牌本身有技能效果，那就无法触发了，因此补充一个触发时机。
     * 由于这个事件不会取消后续事件的触发，所以不需要返回值.
     * @param owner 装备牌的拥有者
     */
    private static void triggerCardSkillBeforeDiscard(class_1309 owner, ExData exData, Trigger t) {
        exData.forEachCard(2, (c, i) -> {
            class_1799 stack = c.toStack();
            if (stack.method_7909() instanceof Equipment) {
                var skill = s(stack);
                for (var data : skill.data()) {
                    if (!List.of(data.trigger()).contains(t) || !data.relation().test(owner, owner, exData.source)) continue;
                    data.apply(owner, owner, skill, exData);
                }
            }
        });
    }

    /**
     * 卡牌被弃置，包括发动技能弃牌，被过河拆桥弃牌，替换装备时弃置旧的装备等情况
     * @param exData 包含被弃置的卡牌数据
     */
    public static void cardDiscard(class_1309 entity, ExData exData) {
        exData.forEachCard(1, (c, i) ->
                getResult(Trigger.SHOULD_DISCARD, entity, entity, d().cards(c, i)) > 0);
        exData.forEachCard(2, (c, i) ->
                getResult(Trigger.SHOULD_DISCARD, entity, entity, d().cards(c, i, true)) > 0);
        triggerCardSkillBeforeDiscard(entity, exData, Trigger.LOSE_CARD_DISCARD);
        exData.forEachCard(3, (c, i) -> {cardDecrement(entity, c.origin(), i);});
        getSkillOwners(entity).forEach(player -> getResult(Trigger.LOSE_CARD_DISCARD, player, entity, exData));
    }

    /**
     * 卡牌从一个生物的区域移动到另一个生物的非装备区域，比如顺手牵羊，仁德给牌等操作
     * @param exData 包含被移动的卡牌数据
     */
    public static void cardMove(class_1309 from, ExData exData, class_1309 to) {
        triggerCardSkillBeforeDiscard(from, exData, Trigger.LOSE_CARD_MOVE);
        exData.forEachCard(3, (c, i) -> {
            cardDecrement(from, c.origin(), i);
            give(to, c.toStack().method_46651(i));
        });
        getSkillOwners(from).forEach(player -> {
            getResult(Trigger.LOSE_CARD_MOVE, player, from, exData);
            getResult(Trigger.GET_CARD_MOVE, player, to, exData);
        });
    }

    /**
     * 卡牌从一个生物的区域移动到另一个生物的装备区，比如直谏技能的效果
     * @param exData 包含被移动的卡牌数据
     */
    public static void cardToEquip(class_1309 from, ExData exData, class_1309 to) {
        triggerCardSkillBeforeDiscard(from, exData, Trigger.LOSE_CARD_MOVE);
        exData.forEachCard(3, (c, i) -> {
            cardDecrement(from, c.origin(), i);
            Equipment.useOrReplaceEquip(to, c.toStack().method_46651(i));
        });
        getSkillOwners(from).forEach(player -> getResult(Trigger.LOSE_CARD_MOVE, player, from, exData));
    }

    public static void hurtByCard(class_1309 entity, class_1282 source, float amount) {
        class_1792 card = switch (source.method_48792().comp_1242()) {
            case "huogong" -> ModItems.FIRE_ATTACK;
            case "juedou" -> ModItems.JUEDOU;
            case "nanman" -> ModItems.NANMAN;
            case "wanjian" -> ModItems.WANJIAN;
            case "shandian" -> ModItems.SHANDIAN_ITEM;
            case "sha" -> ModItems.SHA;
            case "shaFire" -> ModItems.FIRE_SHA;
            case "shaThunder" -> ModItems.THUNDER_SHA;
            default -> class_1799.field_8037.method_7909();
        };
        getSkillOwners(entity).forEach(player ->
                getResult(Trigger.HURT_BY_CARD, player, entity, d().cards(newCard(card), 1).withDamage(source, amount)));
    }

    /**专为处理卡牌减少而写的方法，牌堆中的卡牌减少，需要保存nbt*/
    public static void cardDecrement(class_1309 entity, class_1799 stack, int count) {
        if (entity instanceof class_1657 player) {
            if (getCardPack(player).removeStack(stack, count)) return;
            else stack.method_7934(count);
            return;
        }
        stack.method_7934(count);
    }
    /**卡牌使用后减少，不需要传入原始的itemStack*/
    public static void cardUseAndDecrement(class_1309 user, class_1799 card, class_1268 hand) {
        //即使创造模式，无懈可击也会消耗，为什么呢？我也不知道
        if (card.method_31574(ModItems.WUXIE)) cardDecrement(user, getCard(user, p(ModItems.WUXIE)), 1);
        else {
            //如果使用者是创造模式玩家，则不消耗卡牌
            if (user instanceof class_1657 player && player.method_31549().field_7477) return;
            class_1792 usedItem = card.method_7909();
            //找到和要消耗的完全相同的卡牌，若找不到，则找和要消耗的卡牌同名的牌
            var stack = getCard(user, s -> class_1799.method_7973(s, card));
            if (stack.method_7960()) stack = getCard(user, p(usedItem));
            cardDecrement(user, stack, 1);
            //如果使用者是玩家，且消耗的卡牌stack没了，则尝试补充卡牌
            if (user instanceof class_1657 player && stack.method_7960()) {
                if (isSha.test(usedItem.method_7854())) { //如果使用了杀则补充杀，否则补充同名牌
                    var s = getCard(user, isSha);
                    if (!s.method_7960()) {
                        if (hand != null) player.method_6122(hand, s.method_7972()); else give(player, s.method_7972());
                        cardDecrement(player, s, s.method_7947());
                    }
                } else if (hand != null && player.method_5998(hand).method_7960()) {
                    var s = getCard(user, p(usedItem));
                    if (!s.method_7960()) {player.method_6122(hand, s.method_7972()); cardDecrement(player, s, s.method_7947());}
                }
            }
        }
    }
}
