package com.amotassic.dabaosword.api.card;

import com.amotassic.dabaosword.item.ModItems;
import com.amotassic.dabaosword.item.card.CardItem;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2561;

/**
 * 一个用于存放卡牌物品堆的类，包含了卡牌的类型、花色、点数、数量等信息，以及一些用于操作卡牌的方法。
 * 当然，这个类也可以用于存放其他物品而不会报错，只是没有卡牌应有的属性。
 * @author Amotassic
 */
public final class Card {
    private final class_1799 card;
    private final class_1799 copy;
    private final CardItem item;
    public final int type;
    public final Suit suit;
    public final Rank rank;
    public int count;
    public static final int BASIC = 0, ARMOURY = 1, EQUIPMENT = 2;

    public Card(CardItem item, Suit suit, Rank rank) {
        this.card = this.copy = class_1799.field_8037;
        this.item = item;
        this.type = item.getType();
        this.suit = suit;
        this.rank = rank;
        this.count = 1;
    }

    public Card(CardItem item) {this(item, Suit.None, Rank.None);}

    public Card(class_1799 card) {
        this.card = card; this.copy = card.method_7972();
        this.item = card.method_7909() instanceof CardItem c ? c : ModItems.EMPTY_CARD;
        this.type = item.getType();
        this.count = card.method_7947();
        var nbt = card.method_7948();
        this.suit = count == 0 ? Suit.None : Suit.fromNbt(nbt);
        this.rank = count == 0 ? Rank.None : Rank.fromNbt(nbt);
    }

    public CardItem item() {return this.item;}

    public boolean isFromStack() {return !this.copy.method_7960();}

    public class_1799 origin() {return card;}

    public class_1799 toStack() {
        if (isFromStack()) return copy.method_7972();
        var stack = new class_1799(item, count); var nbt = new class_2487();
        if (suit != Suit.None) nbt.method_10582("Suit", suit.name());
        if (rank != Rank.None) nbt.method_10582("Rank", rank.rank);
        stack.method_7980(nbt);
        return stack;
    }

    public boolean askForWuxie() {
        if (item instanceof CardItem.Armoury a) return a.askForWuxie();
        return false;
    }

    public void effect(class_1309 user, class_1799 card, class_1309 target) {
        this.item.effect(user, card, target);
    }

    public boolean isOf(class_1792 item) {return this.item == item;}

    public class_2561 getName() {return this.item.method_7848();}

    public String toString() {return card + ", suit=" + suit + ", rank=" + rank;}

}
