package com.amotassic.dabaosword.api.skill;

import com.amotassic.dabaosword.api.TriPredicate;
import com.amotassic.dabaosword.item.ModItems;
import com.amotassic.dabaosword.item.skillcard.SkillItem;
import com.amotassic.dabaosword.ui.PlayerInvScreenHandler;
import dev.emi.trinkets.api.SlotReference;
import dev.emi.trinkets.api.Trinket;
import java.util.List;
import net.minecraft.class_1282;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1713;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_5250;

import static com.amotassic.dabaosword.util.ModTools.s;
import static net.minecraft.class_124.*;

public interface ISkill extends Trinket {
    TriPredicate<class_1309, class_1309, class_1282>
    ANY = (o, t, s) -> true,
    SELF = (o, t, s) -> o == t,
    NOT_SELF = (o, t, s) -> o != t,
    ATTACKER = (o, t, s) -> s != null && s.method_5529() == o,
    DIRECT_ATTACKER = (o, t, s) -> s != null && s.method_5526() == o,
    KILLER = (o, t, s) -> t.method_29504() && (s != null && s.method_5529() == o || t.method_6124() == o);

    /**判断该技能是否拥有锁定技标签（只关系到其是否会被铁骑锁住）
     * @see Skill#lockOn() */
    default boolean lockOn() {return false;}

    /**是否是需要主动使用的技能，即必须通过客户端按下快捷键触发*/
    default boolean isActiveSkill() {return false;}

    /**无需指定其他玩家为目标的主动技效果
     * @return 如果生效则返回true*/
    default boolean activeSkill(class_1657 user, Skill skill) {return false;}

    default boolean activeSkill(class_1657 user, Skill skill, class_1309 target) {return false;}

    @Override
    default void onEquip(class_1799 stack, SlotReference slot, class_1309 entity) {
        if (entity.method_37908() instanceof class_3218 world && !equipped(stack)) {
            world.method_18456().forEach(player -> player.method_43496(
                    class_2561.method_43469("dabaosword.entity.equip", entity.method_5476(), stack.method_7954())
            ));
            setEquipped(stack, true);
        }
    }

    default boolean equipped(class_1799 stack) {return stack.method_7948().method_10545("equipped");}

    default void setEquipped(class_1799 stack, boolean equipped) {
        class_2487 nbt = stack.method_7948();
        if (equipped) nbt.method_10556("equipped", true);
        else nbt.method_10551("equipped");
        stack.method_7980(nbt);
    }

    @Override
    default void tick(class_1799 stack, SlotReference slot, class_1309 entity) {
        if (stack.method_7909() instanceof SkillItem && entity.method_5752().contains("duanchang")) return;
        Skill skill = s(stack);
        if (skill.lockOn() || !entity.method_6059(ModItems.TIEJI)) tickSkill(skill, entity);
        if (entity.method_37908() instanceof class_3218 world) {
            int cd = skill.getCD(); //世界时间除以20取余为0时，技能内置CD减一秒
            if (cd > 0 && world.method_8510() % 20 == 0) {
                if (entity instanceof class_1657 player && player.method_31549().field_7477) skill.setCD(0);
                else skill.setCD(cd - 1);
            }
        }
    }

    /**当玩家被断肠或者非锁定技失效时，此效果将无法触发*/
    default void tickSkill(Skill skill, class_1309 entity) {}

    default boolean shouldTickUpdate() {return false;}
    default void tickUpdateNbt(Skill skill, class_1309 entity) {
        int tick = (int) (entity.method_37908().method_8510() % 20);
        var nbt = skill.getNbt();
        nbt.method_10569("TickOfSecond", tick);
        skill.setNbt(nbt);
    }

    /**在打开的GUI上添加操作提示，可按需添加，默认会添加物品本身的物品提示
     * @see ISkill#addPresetTips(Skill, List, Integer...) */
    default void addScreenTip(Skill skill, List<class_2561> tips) {
        tips.add(skill.toHoverableText());
        if (skill.stack.method_7909() instanceof SkillItem si) si.addTip(skill, tips);
    }

    /**
     * 预设的GUI界面提示信息，按需填写即可。
     * @param presetLines 可以填写的预设的信息如下：
     * <ul>
     *     <li>0：标题以及关闭GUI确定选择操作提示</li>
     *     <li>1：左键右键操作提示</li>
     *     <li>2：鼠标滚轮操作提示</li>
     *     <li>3：Shift+左/右键操作提示，若限制最大选牌数量则不显示</li>
     *     <li>4：全选（若限制最大选牌数量则不显示）、取消全选操作的提示</li>
     *     <li>5：最大可选数量、最小可选数量（如果没有限制则为空）的提示</li>
     * </ul>
     */
    default void addPresetTips(Skill skill, List<class_2561> tips, Integer... presetLines) {
        var preset = List.of(presetLines);
        int max = skill.getMaxSelect(); int min = skill.getMinSelect();
        for (Integer i : preset) {
            switch (i) {
                case 0 -> tips.add(class_2561.method_43471("screen.dabaosword.title").method_27695(field_1075, field_1067).method_10852(class_2561.method_43471("screen.dabaosword.title_").method_27695(field_1061, field_1067)));
                case 1 -> tips.add(class_2561.method_43471("screen.dabaosword.tip1").method_27692(field_1067));
                case 2 -> tips.add(class_2561.method_43471("screen.dabaosword.tip2").method_27695(field_1075, field_1067));
                case 3 -> {
                    if (max > 100) tips.add(class_2561.method_43471("screen.dabaosword.tip3").method_27692(field_1067));
                }
                case 4 -> {
                    class_5250 text = max >= 100 ? class_2561.method_43471("screen.dabaosword.ctrl_a").method_27695(field_1075, field_1067) : class_2561.method_43470("");
                    tips.add(text.method_10852(class_2561.method_43471("screen.dabaosword.ctrl_z").method_27695(field_1075, field_1067)));
                }
                case 5 -> {
                    class_5250 minText = min > 0 ? class_2561.method_43469("screen.dabaosword.min_tip", min).method_27695(field_1061, field_1067) : class_2561.method_43470("");
                    class_5250 maxText = max < 100 ? class_2561.method_43469("screen.dabaosword.max_tip", max).method_27695(field_1061, field_1067) : class_2561.method_43470("");
                    tips.add(minText.method_10852(maxText));
                }
            }
        }
    }

    /**当玩家点击技能打开的GUI中的物品后，会发生的操作逻辑，会影响玩家是否能选取卡牌。如果需要实现自定义的选取逻辑，请重写这个方法*/
    default void onSlotClick(PlayerInvScreenHandler handler, class_1657 player, Skill skill, class_1657 target, int slot, int button, class_1713 action) {
        if (action == class_1713.field_7790) { //左键点击+1，右键点击-1
            if (button == 0) handler.addClick(slot, 1);
            if (button == 1) handler.dropClick(slot, 1);
        } else if (action == class_1713.field_7794) { //shift+左键选一组，shift+右键取消选一组
            if (button == 0) handler.addClick(slot, 99);
            if (button == 1) handler.setClick(slot, 0);
        } else if (action == class_1713.field_7791 && 0 <= button && button < 9) { //数字键按下几就选几个
            handler.setClick(slot, button + 1);
        }
    }

    /**当选牌GUI被关闭后，即玩家确认选牌后，需要处理选牌的逻辑*/
    default void onGuiClose(PlayerInvScreenHandler handler, class_1657 player, Skill skill, class_1657 target) {}

    /**这个方法是用于在子类重写，以此快速生成一个带有参数的方法。
     * <p>
     * 加上{@link SkillInfo}注解后，子类的方法可以随意改名，但是这里该有的参数一个也不能少！
     * @return 除了取消伤害五个触发时机的技能需要返回大于0的值，其余请直接返回0*/
    @SuppressWarnings("unused")
    default int skillPattern(class_1309 user, class_1309 target, Skill skill, ExData data) {return 0;}

    /**在玩家打中生物实体后，但还没有进行伤害结算时触发*/
    default void preAttack(class_1657 player, class_1309 target, Skill skill) {}

    default int getExtraReach(class_1309 entity, Skill skill) {return 0;}

    default int getDefend(class_1309 entity, Skill skill) {return 0;}

    /**摸牌阶段开始时触发
     * @return 摸牌阶段多摸牌的数量，返回负值就减少摸牌数，若返回值小于等于-114，直接取消摸牌。*/
    default int onDrawPhase(class_1657 player, Skill skill) {return 0;}

}
