package com.amotassic.dabaosword.client;

import com.amotassic.dabaosword.network.ServerNetworking;
import com.amotassic.dabaosword.util.ModTools;
import com.amotassic.dabaosword.util.Tags;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.minecraft.class_1041;
import net.minecraft.class_1799;
import net.minecraft.class_2540;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_5481;
import net.minecraft.class_746;
import java.util.ArrayList;
import java.util.List;

public class ChangeSkillRender implements HudRenderCallback {
    private static final class_310 client = class_310.method_1551();
    public static boolean isRendering = false;
    private static int screenWidth;
    private static int screenHeight;
    private static int centerX;
    private static int centerY;
    private static List<class_1799> skills = new ArrayList<>();

    @Override
    public void onHudRender(class_332 drawContext, float tickDelta) {
        class_746 player = client.field_1724;
        if (!isRendering || player == null) return;
        if (skills.isEmpty()) skills = ModTools.trinketsWithSlots(player, s -> s.method_31573(Tags.SKILLS)).stream().map(p -> p.method_15442().method_5438(p.method_15441())).toList();
        if (skills.size() < 2) {
            close();
            client.field_1729.method_1612();
            return;
        }

        class_327 textRenderer = client.field_1772;
        screenWidth = client.method_22683().method_4486();
        screenHeight = client.method_22683().method_4502();
        centerX = screenWidth / 2;
        centerY = screenHeight / 2;
        int radius = 80; // 离原点的半径
        int n = skills.size();

        for (int i = 0; i < n; i++) {
            // 计算每个扇形的角度（弧度），以竖直向上为0°，顺时针为正
            float angle = (float) (2 * Math.PI * i / n - Math.PI / 2);
            // 计算文本坐标（注意Minecraft的Y轴向下为正）
            int x = centerX + (int) (radius * Math.cos(angle));
            int y = centerY + (int) (radius * Math.sin(angle));
            // 绘制文本（x,y为文本左上角坐标，需调整以居中显示）
            class_1799 skill = skills.get(i);
            class_5481 text = skill.method_7954().method_30937();
            drawContext.method_51427(skill, x - 8, y - 16);
            drawContext.method_51430(textRenderer, text, x - textRenderer.method_30880(text) / 2, y, 0xFFFFFF, false);
        }
    }

    public static void close() {
        isRendering = false;
        skills = new ArrayList<>();
    }

    public static void handleSkillSelect(double x, double y) {
        if (!isRendering) return;

        double angleDegrees = getAngleDegrees(x, y);
        int parts = skills.size();
        double partAngle = 360.0 / parts;
        double fixedDegree = angleDegrees + partAngle / 2;
        if (fixedDegree >= 360) fixedDegree -= 360;
        int part = (int) (fixedDegree / partAngle);
        close();
        if (part <= 0) return;

        // System.out.printf("鼠标与中心夹角: %.2f°，所在部分: %d\n", angleDegrees, part);
        class_2540 buf = PacketByteBufs.create();
        buf.writeInt(part + 100);
        ClientPlayNetworking.send(ServerNetworking.SELECT_CARD, buf);
    }

    private static double getAngleDegrees(double x, double y) {
        var clientWindow = client.method_22683();
        double d = x * (double) screenWidth / (double) clientWindow.method_4480();
        double e = y * (double) screenHeight / (double) clientWindow.method_4507();
        // 计算鼠标相对于中心的偏移量（注意y轴方向需要反转，因为屏幕坐标向下为正）
        double offsetX = d - centerX;
        double offsetY = centerY - e;  // 反转Y轴，使向上为正方向
        // 计算夹角（弧度制），使用atan2(dx, dy)确保0°在竖直向上方向
        double angleRadians = Math.atan2(offsetX, offsetY);
        // 转换为角度制
        double angleDegrees = Math.toDegrees(angleRadians);
        // 确保角度在0-360°范围内
        if (angleDegrees < 0) angleDegrees += 360;
        return angleDegrees;
    }
}
