package com.amotassic.dabaosword.client;

import com.amotassic.dabaosword.DabaoSword;
import com.amotassic.dabaosword.api.card.Card;
import com.amotassic.dabaosword.api.card.Rank;
import com.amotassic.dabaosword.api.card.Suit;
import com.amotassic.dabaosword.api.event.KeyInputCallback;
import com.amotassic.dabaosword.entity.ModEntity;
import com.amotassic.dabaosword.entity.client.ModModelLayers;
import com.amotassic.dabaosword.entity.client.XuyouModel;
import com.amotassic.dabaosword.entity.client.XuyouRenderer;
import com.amotassic.dabaosword.item.ModItems;
import com.amotassic.dabaosword.item.card.CardItem;
import com.amotassic.dabaosword.ui.FullInvHandledScreen;
import com.amotassic.dabaosword.ui.PileHandledScreen;
import com.amotassic.dabaosword.ui.PlayerInvHandledScreen;
import java.util.List;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.rendering.v1.EntityModelLayerRegistry;
import net.fabricmc.fabric.api.client.rendering.v1.EntityRendererRegistry;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_2960;
import net.minecraft.class_3929;
import net.minecraft.class_7923;

import static com.amotassic.dabaosword.util.ModTools.c;
import static net.minecraft.class_5272.method_27879;

public class DabaoSwordClient implements ClientModInitializer {
    @Override
    public void onInitializeClient() {
        HudRenderCallback.EVENT.register(new TiesuoHud());
        HudRenderCallback.EVENT.register(new ChangeSkillRender());
        class_3929.method_17542(ModItems.PLAYER_INV_SCREEN_HANDLER, PlayerInvHandledScreen::new);
        class_3929.method_17542(ModItems.FULL_INV_SCREEN_HANDLER, FullInvHandledScreen::new);
        class_3929.method_17542(ModItems.PILE_SCREEN_HANDLER, PileHandledScreen::new);
        ClientTickEnd.initialize();
        registerPredicates();
        EntityModelLayerRegistry.registerModelLayer(ModModelLayers.XUYOU, XuyouModel::getTexturedModelData);
        EntityRendererRegistry.register(ModEntity.XUYOU, XuyouRenderer::new);
        KeyInputCallback.KEY_INPUT.register(new KeyInputHandler());
    }

    private void registerPredicates() {
        //用于改变铁索连环的纹理
        method_27879(ModItems.TIESUO, new class_2960("nahida"), (stack, clientWorld, livingEntity, seed) -> {
            if (livingEntity == null) return 0.0F;
            return livingEntity.method_6079().method_31574(class_1802.field_8361) ? 1.0F : 0.0F;
        });
        //用于添加卡牌的花色和点数
        var itemList = class_7923.field_41178.method_10220().filter(item -> item instanceof CardItem).toList();
        for (var item : itemList) {registerCustomModelPredicate(item);}
    }

    private void registerCustomModelPredicate(class_1792 item) {
        method_27879(item, class_2960.method_43902(DabaoSword.MOD_ID, item.toString() + "_sr"), (stack, clientWorld, livingEntity, seed) -> {
            var card = c(stack);
            var s = card.suit; var r = card.rank;
            if (s != Suit.None && r != Rank.None) {
                int suit = s.ordinal();
                int rank = r.ordinal() + 1;
                return (float) (0.13 * suit + 0.01 * rank);
            }
            return 0.0F;
        });
    }
}
