package com.amotassic.dabaosword.datagen;

import com.amotassic.dabaosword.item.ModItems;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricAdvancementProvider;
import net.minecraft.class_161;
import net.minecraft.class_170;
import net.minecraft.class_189;
import net.minecraft.class_2066;
import net.minecraft.class_2135;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;

public class AdvancementsProvider extends FabricAdvancementProvider {
    public AdvancementsProvider(FabricDataOutput output) {super(output);}

    @Override
    public void generateAdvancement(Consumer<class_161> consumer) {
        for (String name : ADVANCEMENTS.keySet()) {
            ADVANCEMENTS.get(name).method_694(consumer, name);
        }
    }

    private static final Map<String, class_161.class_162> ADVANCEMENTS = new HashMap<>();

    private static class_161 add(String name, class_161.class_162 builder) {
        ADVANCEMENTS.put(name, builder);
        class_2960 id = new class_2960("dabaosword", name);
        return builder.method_695(id);
    }

    public static class_161 get(String name) {
        class_2960 id = new class_2960("dabaosword", name);
        return ADVANCEMENTS.get(name).method_695(id);
    }

    private static final class_161 root = add("root", class_161.class_162.method_707()
            .method_706(class_170.class_171.method_34901(new class_2960("dabaosword", "root")).method_751())
            .method_697(ModItems.BBJI,
                    class_2561.method_43471("advancement.dabaosword.root.title"),
                    class_2561.method_43471("advancement.dabaosword.root.tip"),
                    new class_2960("textures/gui/advancements/backgrounds/adventure.png"),
                    class_189.field_1254, true, false, false
            ).method_709("root", class_2135.class_2137.method_49195()));

    static {
        add("card_pile", class_161.class_162.method_707().method_701(root)
                .method_697(ModItems.CARD_PILE,
                        class_2561.method_43471("advancement.dabaosword.card_pile.title"),
                        class_2561.method_43471("advancement.dabaosword.card_pile.tip"),
                        null,
                        class_189.field_1254, true, true, false
                ).method_709("card_pile", class_2066.class_2068.method_8959(ModItems.CARD_PILE)));

        add("gift_box", class_161.class_162.method_707().method_701(root)
                .method_697(ModItems.GIFTBOX,
                        class_2561.method_43471("advancement.dabaosword.gift_box.title"),
                        class_2561.method_43471("advancement.dabaosword.gift_box.tip"),
                        null,
                        class_189.field_1254, true, true, false
                ).method_709("gift_box", class_2066.class_2068.method_8959(ModItems.GIFTBOX)));
    }
}
