package com.amotassic.dabaosword.event;

import com.amotassic.dabaosword.api.CardPileInventory;
import com.amotassic.dabaosword.api.event.PVPGameTickCallback;
import com.amotassic.dabaosword.item.ModItems;
import com.amotassic.dabaosword.pvpgame.Game;
import com.amotassic.dabaosword.pvpgame.Game.Identity;
import com.amotassic.dabaosword.pvpgame.GameManager;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerWorldEvents;
import net.minecraft.class_124;
import net.minecraft.class_1937;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_266;
import net.minecraft.class_274;
import net.minecraft.class_2995;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_5250;
import net.minecraft.server.MinecraftServer;
import java.util.*;

import static com.amotassic.dabaosword.util.ModTools.*;

public class PVPGameEvents implements ServerWorldEvents.Load, ServerTickEvents.StartTick, ServerTickEvents.StartWorldTick, PVPGameTickCallback {
    private static GameManager gameManager;

    public static GameManager getGameManager() {return gameManager;}

    @Override
    public void onWorldLoad(MinecraftServer server, class_3218 world) {
        //只需要保存在主世界的data目录下即可
        if (world.method_27983() == class_1937.field_25179) gameManager = world.method_17983().method_17924(nbt -> GameManager.fromNbt(world, nbt), () -> new GameManager(world), "dabaosword_game");
    }

    @Override
    public void onStartTick(class_3218 world) {
        //防止每个维度都加载一次，暂时不知道用什么更优雅的办法
        if (world.method_27983() == class_1937.field_25179) gameManager.tick();
    }

    @Override
    public void onGameTick(Game game, class_3218 world) {
        int countDown = game.getCountDown();

        if (game.isWaiting()) countDownTip(game, countDown);
        if (countDown == 0) onGameStart(game, world);
        if (game.isOn()) handleTimeOut(game, game.getTimeOut());

        if (game.neiLives <= 0) { //内奸和另一个队伍已淘汰，谁活着谁就胜利
            if (game.fanLives <= 0) game.win(Game.Identity.ZHONG);
            if (game.zhongLives <= 0) game.win(Game.Identity.FAN);
        } else {
            if (game.fanLives <= 0) {
                twoTeam(game, Game.Identity.ZHONG);
                if (game.zhongLives <= 0) game.win(Game.Identity.NEI); //忠臣反贼都淘汰，内奸胜利（无人得分才可能会这样）
            }
            if (game.zhongLives <= 0) twoTeam(game, Game.Identity.FAN);
        }
    }

    public static void onGameCreate(class_3222 player, Game game, Set<UUID> players) {
        class_5250 text = class_2561.method_43469("dabaosword.game.create", player.method_5476(), players.size());
        if (game.getPrimaryData().get("neiCount") == 0) text = text.method_10852(class_2561.method_43471("dabaosword.game.no_turn_coat"));
        class_5250 finalText = text;
        game.forEachPlayer(p -> p.method_43496(finalText));
    }

    private void countDownTip(Game game, int countDown) {
        if (countDown % 20 != 0) return;
        game.forEachPlayer(player -> {
            if (countDown % 100 == 0) {
                class_2561 quit = class_2561.method_43471("dabaosword.refuse").method_27692(class_124.field_1061).method_27694(style -> style.method_10958(new class_2558(class_2558.class_2559.field_11750, "/dabaosword refusegame")).method_10949(class_2568.class_5247.field_24342.method_27671(class_2561.method_43471("dabaosword.refuse_hover"))));
                player.method_43496(class_2561.method_43469("dabaosword.game.wait", countDown / 20).method_10852(quit));
                return;
            }
            Set<Integer> times = Set.of(60, 40, 20);
            if (times.contains(countDown)) {
                voice(player, class_3417.field_14793.comp_349());
                title(player, class_2561.method_43470(String.valueOf(countDown / 20)));
            }
        });
    }

    private void onGameStart(Game game, class_3218 world) {
        //添加死亡计分板
        var scoreboard = world.method_8503().method_3845();
        var obj = scoreboard.method_1165("dabaosword.death");
        var criterion = class_274.field_1456;
        if (obj == null) obj = scoreboard.method_1168("dabaosword.death", criterion, class_2561.method_43471("dabaosword.score.death"), criterion.method_1227());
        scoreboard.method_1158(1, obj);

        game.forEachPlayer(player -> {
            var identity = game.getIdentity(player);
            class_124 color = Game.getIdentityColor(identity);
            class_2561 o1 = class_2561.method_43471(identity.tag); class_2561 o2 = class_2561.method_43471(identity.tag + ".tip");
            class_2561 o3 = class_2561.method_43469("dabaosword.game.start.tip", o1, o2).method_27692(color);
            title(player, class_2561.method_43471("dabaosword.game.start").method_27692(class_124.field_1065));
            subtitle(player, o3); player.method_43496(o3);
            voice(player, class_3417.field_17266.comp_349(), 32);
        });
    }

    private void handleTimeOut(Game game, int timeOut) {
        if (game.getGameTime() % 20 != 0) return;
        if (timeOut == 60 || timeOut == 30) game.forEachPlayer(player -> player.method_43496(class_2561.method_43469("dabaosword.game.timeout.warn", timeOut).method_27692(class_124.field_1054)));
        if (timeOut == 0) game.timeOut();
    }

    /**当反贼或忠臣被淘汰后，仅剩下内奸和另外一队，判定哪队胜利
     * @param identity 除内奸外存活的队伍*/
    private void twoTeam(Game game, Game.Identity identity) {
        var nei = Game.Identity.NEI; if (identity == nei) return; //防呆设计
        if (game.getScore(identity) > game.neiScore) game.win(identity);
        if (game.getScore(identity) < game.neiScore) game.win(nei);
    }

    public static final Map<class_3222, CardPileInventory> PLAYER_CARD_PACKS = new HashMap<>();

    @Override
    public void onStartTick(MinecraftServer server) {
        List<class_3222> playerList = server.method_3760().method_14571();
        for (var player : playerList) {
            if (!PLAYER_CARD_PACKS.containsKey(player) && hasTrinket(ModItems.CARD_PILE, player)) PLAYER_CARD_PACKS.put(player, new CardPileInventory(player));
        }
        PLAYER_CARD_PACKS.keySet().removeIf(player -> player == null || player.method_31481() || !hasTrinket(ModItems.CARD_PILE, player));
    }
}
