package com.amotassic.dabaosword.item.card.equipment;

import com.amotassic.dabaosword.api.card.Card;
import com.amotassic.dabaosword.api.skill.*;
import com.amotassic.dabaosword.item.ModItems;
import com.amotassic.dabaosword.util.ModifyDamage;
import java.util.List;
import java.util.Random;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1667;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_3612;
import net.minecraft.class_8103;

import static com.amotassic.dabaosword.util.ModTools.*;
import static net.minecraft.class_124.field_1075;

public class Armor extends Equipment {

    public static class Bagua extends Armor {
        public void addTip(Skill skill, List<class_2561> tooltip) {tooltip.add(getTip(field_1075));}

        @SkillInfo(trigger = Trigger.CANCEL_DAMAGE_HIGH, relation = Relation.SELF)
        public int bagua(class_1309 user, class_1309 target, Skill skill, ExData data) {
            class_1282 source = data.source;
            if (source.method_5529() instanceof class_1309 && !user.method_6059(ModItems.COOLDOWN2)) {
                if (new Random().nextFloat() < 0.5 && !source.method_48789(class_8103.field_42241)) {
                    voice(user, this);
                    class_1799 shan = new class_1799(ModItems.SHAN);
                    onUse(user, shan, null, true, false);
                    ModifyDamage.shan(user, true, source, data.amount);
                    return 1;
                }
            }
            return 0;
        }
    }

    public static class Baiyin extends Armor {
        public void addTip(Skill skill, List<class_2561> tooltip) {tooltip.add(getTip(field_1075));}

        @SkillInfo(trigger = Trigger.MODIFY_DAMAGE, relation = Relation.SELF)
        public int jianshang(class_1309 user, class_1309 target, Skill skill, ExData data) {
            var source = data.source; var muls = data.muls;
            if (!source.method_48789(class_8103.field_42242) && source.method_5529() instanceof class_1309) {
                voice(target, this);
                muls.add(-0.4f);
            }
            return 0;
        }

        @SkillInfo(trigger = {Trigger.LOSE_CARD_DISCARD, Trigger.LOSE_CARD_MOVE}, relation = Relation.SELF)
        public int recover(class_1309 user, class_1309 target, Skill skill, ExData data) {
            if (user.method_5805() && user.method_6032() < user.method_6063()) {
                for (var card : data.cards_from_equ.keySet()) {
                    if (card.toStack().method_31574(this)) {
                        voice(user, this);
                        user.method_6025(5);
                    }
                }
            }
            return 0;
        }
    }

    public static class Renwang extends Armor {
        @Override
        public void addTip(Skill skill, List<class_2561> tooltip) {
            tooltip.add(getTip("1"));
            tooltip.add(getTip("2", field_1075));
        }

        @SkillInfo(trigger = Trigger.DROP_TARGET, relation = Relation.ANY)
        public int fangheisha(class_1309 user, class_1309 target, Skill skill, ExData data) {
            if (data.targets.contains(user) && isSha.and(isBlackCard).test(data.getFirst().toStack())) {
                voice(user, this); data.removeTarget(user);
            }
            return 0;
        }
    }

    public static class Rattan extends Armor {
        public void addTip(Skill skill, List<class_2561> tooltip) {tooltip.add(getTip());}

        //实现渡江不沉的效果，代码来自https://github.com/focamacho/RingsOfAscension/中的水上行走戒指
        @Override
        public void tickSkill(Skill skill, class_1309 entity) {
            if (entity.method_5715()) return;
            class_1937 world = entity.method_37908();
            class_2338 pos = entity.method_24515();
            boolean water = !world.method_8316(pos).method_39360(class_3612.field_15910) && world.method_8316(pos.method_10074()).method_39360(class_3612.field_15910);

            if (water && entity.method_19538().field_1351 - pos.method_10264() < 0.15) {
                class_243 motion = entity.method_18798();
                entity.method_18800(motion.field_1352, 0.0D, motion.field_1350);
                entity.field_6017 = 0;
                entity.method_24830(true);
            }
        }

        @SkillInfo(trigger = Trigger.MODIFY_DAMAGE, relation = Relation.SELF)
        public int shouyi(class_1309 user, class_1309 target, Skill skill, ExData data) {
            var source = data.source; var adds = data.adds; var amount = data.amount;
            //穿藤甲时，若承受火焰伤害，则 战火燃尽，嘤熊胆！（伤害大于5就只加5）
            if (source.method_48789(class_8103.field_42246)) {
                voice(target, "rattan_armor2");
                adds.add(Math.min(amount, 5f));
            }
            return 0;
        }

        @SkillInfo(trigger = Trigger.DROP_TARGET, relation = Relation.ANY)
        public int goodEffect(class_1309 user, class_1309 target, Skill skill, ExData data) {
            var card = data.getFirst().toStack();
            boolean bl = card.method_31574(ModItems.WANJIAN) || card.method_31574(ModItems.NANMAN) || card.method_31574(ModItems.SHA);
            if (data.targets.contains(user) && bl) {
                voice(user, this); data.removeTarget(user);
            }
            return 0;
        }

        @SkillInfo(trigger = Trigger.CANCEL_DAMAGE_HIGH, relation = Relation.SELF)
        public int tengjia(class_1309 user, class_1309 target, Skill skill, ExData data) {
            var source = data.source;
            //弹射物对藤甲无效
            if (source.method_48789(class_8103.field_42247)) {
                class_1297 projectile = source.method_5526();
                if (projectile instanceof class_1667) { //即使处于CD中，箭也对藤甲无效
                    projectile.method_31472(); voice(target, this);
                    return 1;
                }
                if (skill.getCD() == 0) {
                    if (projectile != null) projectile.method_31472();
                    target.method_6092(new class_1293(ModItems.INVULNERABLE, 10,0,false,false,false));
                    skill.setCD(5); voice(target, this);
                    return 1;
                }
            }
            //若攻击者主手没有物品，则无法击穿藤甲
            if (source.method_5526() instanceof class_1309 s && s.method_6047().method_7960()) {
                if (skill.getCD() == 0) {
                    target.method_6092(new class_1293(ModItems.INVULNERABLE, 10,0,false,false,false));
                    skill.setCD(5); voice(target, this);
                    return 1;
                }
            }
            return 0;
        }
    }
}
