package com.amotassic.dabaosword.item.card.equipment;

import com.amotassic.dabaosword.api.card.Card;
import com.amotassic.dabaosword.api.skill.ISkill;
import com.amotassic.dabaosword.api.skill.Skill;
import com.amotassic.dabaosword.item.card.CardItem;
import dev.emi.trinkets.TrinketSlot;
import dev.emi.trinkets.api.SlotReference;
import dev.emi.trinkets.api.TrinketsApi;
import java.util.List;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_437;

import static com.amotassic.dabaosword.api.CardEvents.cardDiscard;
import static com.amotassic.dabaosword.util.ModTools.*;
import static net.minecraft.class_124.field_1067;

public class Equipment extends CardItem implements ISkill {
    public Equipment() {
        super(new class_1793().method_7889(1));
        TrinketsApi.registerTrinket(this, this);
    }

    public final int getType() {return Card.EQUIPMENT;}

    public final boolean lockOn() {return true;}

    @Override
    public void method_7888(class_1799 stack, class_1937 world, class_1297 entity, int slot, boolean selected) {
        if (!world.field_9236 && equipped(stack)) setEquipped(stack, false);
    }

    @Override
    public final void method_7851(class_1799 stack, class_1937 world, List<class_2561> tooltip, class_1836 context) {
        addSRTip(c(stack), tooltip); addTip(s(stack), tooltip);

        if (class_437.method_25442()) {
            tooltip.add(class_2561.method_43471("equipment.tip1").method_27692(field_1067));
            tooltip.add(class_2561.method_43471("equipment.tip2").method_27692(field_1067));
        } else tooltip.add(class_2561.method_43469("dabaosword.shift_tip", class_2561.method_43472("key.sneak")));
    }
    public void addTip(Skill skill, List<class_2561> tooltip) {}
    /**防止重写错方法*/
    public final void addTip(class_1799 stack, List<class_2561> tooltip) {}

    @Override
    public final boolean canUnequip(class_1799 stack, SlotReference slot, class_1309 entity) {
        if (entity instanceof class_1657 player && !player.method_7337()) return false;
        return ISkill.super.canUnequip(stack, slot, entity);
    }

    public final void tick(class_1799 stack, SlotReference slot, class_1309 entity) {
        ISkill.super.tick(stack, slot, entity);
    }

    @Override
    public class_1271<class_1799> method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        class_1799 stack = user.method_5998(hand);
        if (!world.field_9236) {
            onUse(user, stack, hand, user);
            return class_1271.method_22427(stack);
        }
        return class_1271.method_22430(stack);
    }

    @Override
    public final void effect(class_1309 user, class_1799 card, class_1309 target) {
        useOrReplaceEquip(target, card);
    }

    public static void useOrReplaceEquip(class_1309 user, class_1799 stack) {
        final SlotReference[] firstSlot = {null};
        TrinketsApi.getTrinketComponent(user).ifPresent(comp -> {
            comp.getInventory().values().forEach(group ->
                    group.values().forEach(inv -> {
                                for (int i = 0; i < inv.method_5439(); i++) {
                                    class_1799 s = inv.method_5438(i);
                                    SlotReference ref = new SlotReference(inv, i);
                                    if (TrinketSlot.canInsert(stack, ref, user)) {
                                        if (s.method_7960()) { //如果这个槽位没有物品，则直接放入
                                            inv.method_5447(i, stack.method_7972());
                                            return;
                                        } else if (firstSlot[0] == null) firstSlot[0] = ref;
                                        //记录第一个有物品的槽位（也就是说，只能替换同类槽位的第一个物品）
                                    }
                                }
                            }
                    ));

            if (firstSlot[0] != null) { //替换原有装备
                class_1799 preStack = firstSlot[0].inventory().method_5438(firstSlot[0].index());
                cardDiscard(user, d().cards(preStack, preStack.method_7947(), true));
                firstSlot[0].inventory().method_5447(firstSlot[0].index(), stack.method_7972());
            }
        });
    }
}
