package com.amotassic.dabaosword.item.skillcard.skills;

import com.amotassic.dabaosword.api.skill.ExData;
import com.amotassic.dabaosword.api.skill.Skill;
import com.amotassic.dabaosword.item.card.CardItem;
import com.amotassic.dabaosword.item.skillcard.SkillItem;
import com.amotassic.dabaosword.ui.PlayerInvScreenHandler;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.class_1657;
import net.minecraft.class_1713;
import net.minecraft.class_1799;
import net.minecraft.class_2561;

import static com.amotassic.dabaosword.util.ModTools.*;

/**
 * 转换卡牌的技能模板
 * 目前仅适用于将一张牌转化成另一张牌的技能
 */
public abstract class ConvertSkill extends SkillItem {

    /**筛选用来转换的卡牌*/
    public abstract Predicate<class_1799> getConvertFilter();
    /**是否能够选择已经装备的装备牌来转换*/
    public boolean chooseEquipment() {return false;}
    /**转换的目标卡牌*/
    public abstract CardItem convert(class_1799 stack);

    @Override public boolean isActiveSkill() {return true;}

    @Override
    public void addScreenTip(Skill skill, List<class_2561> tips) {
        addPresetTips(skill, tips, 0, 1, 2, 3, 4);
        super.addScreenTip(skill, tips);
    }

    @Override
    public boolean activeSkill(class_1657 user, Skill skill) {
        if (skill.getCD() > 0) return false;
        if (count(user, getConvertFilter(), false, true, chooseEquipment()) > 0) {
            // 仅仅是为了不允许全选
            skill.setMaxSelect(64);
            openInv(user, user, user, skill.toHoverableText(), skill.stack, chooseEquipment(), false, 2);
            return true;
        }
        return false;
    }

    @Override
    public void onSlotClick(PlayerInvScreenHandler handler, class_1657 player, Skill skill, class_1657 target, int slot, int button, class_1713 action) {
        class_1799 clicked = handler.getStack(slot);
        if (getConvertFilter().test(clicked)) {
            super.onSlotClick(handler, player, skill, target, slot, button, action);
        }
    }

    @Override
    public void onGuiClose(PlayerInvScreenHandler handler, class_1657 player, Skill skill, class_1657 target) {
        if (handler.getSelectedCount() > 0) {
            voice(player, this);
            var data = handler.toExData();
            data.forEachCard(3, (card, count) -> {
                class_1799 stack = card.toStack();
                give(player, c(stack, convert(stack)).toStack().method_46651(count));
            });
            data.clearCards(player);
        }
    }
}
