package com.amotassic.dabaosword.item.skillcard.skills;

import com.amotassic.dabaosword.api.card.Card;
import com.amotassic.dabaosword.api.card.Suit;
import com.amotassic.dabaosword.api.skill.*;
import com.amotassic.dabaosword.command.DabaoSwordCommand;
import com.amotassic.dabaosword.damage_type.ModDT;
import com.amotassic.dabaosword.item.ModItems;
import com.amotassic.dabaosword.item.card.CardItem;
import com.amotassic.dabaosword.item.skillcard.SkillItem;
import com.amotassic.dabaosword.ui.PlayerInvScreenHandler;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.function.Predicate;
import net.minecraft.class_1293;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1713;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_5250;
import net.minecraft.class_8103;
import net.minecraft.class_8111;

import static com.amotassic.dabaosword.api.CardEvents.*;
import static com.amotassic.dabaosword.util.ModTools.*;
import static net.minecraft.class_124.*;

import I;

public class Wu {

    public static class Buqu extends SkillItem {
        @Override
        public void addTip(Skill skill, List<class_2561> tooltip) {
            String c = skill.getNbt().method_10558("Chuang");
            if (!c.isEmpty()) tooltip.add(class_2561.method_43470("创：" + c));
            tooltip.add(getTip("1", field_1060));
            tooltip.add(getTip("2", field_1060));
        }

        @Override public boolean lockOn() {return true;}

        @SkillInfo(trigger = Trigger.ON_HURT, relation = Relation.SELF)
        public int onDying(class_1309 user, class_1309 target, Skill skill, ExData data) {
            if (user instanceof class_1657 player && player.method_29504()) {
                var nbt = skill.getNbt(); var chuang = nbt.method_10558("Chuang");
                if (chuang.length() > 36) return 0;
                var card = c(newCard());
                player.method_37908().method_18456().forEach(p -> p.method_43496(class_2561.method_43469("buqu.tip1", player.method_5476(), skill.toHoverableText(), card.toStack().method_7954(), card.rank.rank)));
                if (chuang.isEmpty()) {
                    nbt.method_10582("Chuang", card.rank.rank);
                    voice(player, this);
                    player.method_6033(1);
                } else {
                    if (!chuang.contains(card.rank.rank)) {
                        nbt.method_10582("Chuang", chuang + ", " + card.rank.rank);
                        voice(player, this);
                        player.method_6033(1);
                    } else {
                        voice(player, "zhoutai");
                        if (chuang.split(", ").length < 3) player.method_43496(class_2561.method_43471("buqu.tip2").method_27692(field_1061));
                    }
                }
                skill.setNbt(nbt);
            }
            return 0;
        }

        @SkillInfo(trigger = Trigger.ON_DEATH, relation = Relation.SELF)
        public int die(class_1309 user, class_1309 target, Skill skill, ExData data) {
            var nbt = skill.getNbt(); var chuang = nbt.method_10558("Chuang");
            if (chuang.length() > 6) {
                chuang = chuang.substring(6);
                nbt.method_10582("Chuang", chuang);
            } else nbt.method_10551("Chuang");
            skill.setNbt(nbt);
            return 0;
        }
    }

    public static class Fanjian extends SkillItem implements DabaoSwordCommand.CSkill {
        @Override
        public void addTip(Skill skill, List<class_2561> tooltip) {
            int cd = skill.getCD();
            tooltip.add(class_2561.method_43470(cd == 0 ? "CD: 30s" : "CD: 30s   left: "+ cd +"s"));
            tooltip.add(getTip("1", field_1060));
            tooltip.add(getTip("2", field_1060));
        }
        private static final String FJ = "fanjian";

        @Override public boolean isActiveSkill() {return true;}

        @Override
        public boolean activeSkill(class_1657 user, Skill skill) {
            if (skill.getCD() == 0 && countCards(user) > 0 && !user.method_5752().contains("seen_skill_tip")) {
                user.method_43496(class_2561.method_43469("active_skill.use.tip", skill.toHoverableText(), activeSkillText(user, skill)).method_27692(field_1065));
                user.method_5780("seen_skill_tip");
            } //主动技能使用提示
            return false;
        }

        @Override
        public boolean activeSkill(class_1657 user, Skill skill, class_1309 target) {
            if (user == target) return false; //不能对自己犯贱
            if (skill.getCD() > 0) return false;
            if (target instanceof class_1657 player && countCards(user) > 0) { //有手牌才能发动
                voice(user, this);
                skill.setCD(30);
                addTag(player, FJ, user.method_5477().getString()); //标记玩家用于过时后确定目标
                player.method_43496(class_2561.method_43469("select_a_suit", fanjianText(user, player, Suit.Heart), fanjianText(user, player, Suit.Diamond), fanjianText(user, player, Suit.Spade), fanjianText(user, player, Suit.Club)));
                player.method_43496(class_2561.method_43471("fanjian.time.tip").method_27692(field_1067));
                return true;
            }
            return false;
        }

        private class_5250 fanjianText(class_1657 user, class_1657 player, Suit suit) { //四种花色的提示
            return suit.suit.method_27694(style -> style.method_10958(new class_2558(class_2558.class_2559.field_11750, "/dabaosword " + user.method_5477().getString() + " dabaosword:fanjian " + player.method_5477().getString() + " " + (suit.ordinal() + 1)))).method_27692(suit.color);
        }

        @Override
        public void triggerSkill(class_1309 entity, Skill skill, class_1309 target, int value) {
            if (entity instanceof class_1657 user) {
                if (countCards(user) == 0) {skill.setCD(0); return;} //因为技能延时，所以要判断使用者是否还有手牌，若不满足条件则返还技能CD
                if (value == 0) {this.activeSkill(user, skill, target); return;} //0表示对目标发动技能
                if (skill.getCD() < 21) return; //当目标选择一种花色后，技能CD一定大于21
                voice(user, this);
                List<class_1799> items = getItems(user, isCard, true, false, false, true);
                var card = items.get(new Random().nextInt(items.size())); var c = c(card);
                class_2561 message = class_2561.method_43469("dabaosword.steal", target.method_5476(), user.method_5476(), card.method_7954());
                user.method_43496(message); target.method_43496(message);
                cardMove(user, d().cards(card, 1), target);
                if (c.suit.ordinal() + 1 != value) {
                    // 防止触发杀和闪
                    user.method_5780("sha"); target.method_6092(new class_1293(ModItems.COOLDOWN2, 1));
                    target.method_5643(damageSource(user, class_8111.field_42349), 6);
                }
                skill.setCD(20);
            }
        }

        @Override
        public void tickSkill(Skill skill, class_1309 entity) {
            if (entity instanceof class_1657 player && player.method_37908().method_8510() % 10 == 0) {
                int cd = skill.getCD();
                if (cd == 21 || cd == 0) { //目标超时未选择花色，寻找有标签的目标，随机选择一种花色
                    String tag = FJ + "_" + player.method_5477().getString();
                    Predicate<class_1309> p = e -> hasTag(e, tag);
                    var target = getClosestEntity(player, class_1309.class, 20, p);
                    if (target == null) target = player.method_37908().method_18456().stream().filter(p).findFirst().orElse(null);
                    if (target == null) return;
                    if (cd == 21) this.triggerSkill(player, skill, target, new Random().nextInt(4) + 1);
                    removeTag(target, tag);
                }
            }
        }
    }

    public static class Fenyin extends SkillItem {
        @Override
        public void addTip(Skill skill, List<class_2561> tooltip) {tooltip.add(getTip(field_1060));}

        @SkillInfo(trigger = Trigger.LOSE_CARD_USE, relation = Relation.SELF)
        public int useCard(class_1309 user, class_1309 target, Skill skill, ExData data) {
            var card = data.getFirst().toStack();
            var nbt = skill.getNbt();
            int last = nbt.method_10545("fenyin") ? nbt.method_10550("fenyin") : 0;
            int current = isRedCard.test(card) ? 1 : isBlackCard.test(card) ? 2 : 0;
            if (last != 0 && current != 0 && current != last) {draw(user); voice(user, this);}
            nbt.method_10569("fenyin", current);
            skill.setNbt(nbt);
            return 0;
        }
    }

    public static class Gongxin extends SkillItem {
        @Override
        public void addTip(Skill skill, List<class_2561> tooltip) {
            int cd = skill.getCD();
            tooltip.add(class_2561.method_43470(cd == 0 ? "CD: 30s" : "CD: 30s   left: "+ cd +"s"));
            tooltip.add(getTip(field_1060));
        }

        @Override public boolean isActiveSkill() {return true;}

        @Override
        public boolean activeSkill(class_1657 user, Skill skill, class_1309 entity) {
            if (entity instanceof class_1657 target && countCards(target) > 0) {
                int cd = skill.getCD();
                if (cd > 0) user.method_7353(class_2561.method_43471("dabaosword.cooldown").method_27692(field_1061), true);
                else {
                    voice(user, this);
                    openInv(user, target, target, class_2561.method_43471("gongxin.title"), skill.stack, false, false, 2);
                    skill.setCD(30);
                    return true;
                }
            }
            return false;
        }

        @Override
        public void onSlotClick(PlayerInvScreenHandler handler, class_1657 player, Skill skill, class_1657 target, int slot, int button, class_1713 action) {
            var selected = handler.getStack(slot);
            target.method_43496(class_2561.method_43469("dabaosword.discard", player.method_5476(), target.method_5476(), selected.method_7954()));
            var data = d().cards(selected, 1);
            cardDiscard(target, data);
            closeGUI(player);
        }
    }

    public static class Guose extends ConvertSkill {
        @Override
        public void addTip(Skill skill, List<class_2561> tooltip) {
            tooltip.add(getTip(field_1060));
        }

        @Override public boolean chooseEquipment() {return true;}
        @Override public Predicate<class_1799> getConvertFilter() {return isDiamondCard;}
        @Override public CardItem convert(class_1799 stack) {return ModItems.TOO_HAPPY_ITEM;}
    }

    public static class Kurou extends SkillItem {
        @Override
        public void addTip(Skill skill, List<class_2561> tooltip) {tooltip.add(getTip(field_1060));}

        @Override public boolean isActiveSkill() {return true;}

        @Override
        public boolean activeSkill(class_1657 user, Skill skill) {
            if (user.method_6032() + 5 * countCard(user, canSaveDying) > 4.99) {
                draw(user, 2);
                if (!user.method_7337()) {
                    user.field_6008 = 0;
                    user.method_5643(ModDT.loseHP(user), 4.99f);
                }
                voice(user, this);
                return true;
            } else {user.method_7353(class_2561.method_43471("item.dabaosword.kurou.tip").method_27692(field_1061), true);}
            return false;
        }
    }

    public static class Lianying extends SkillItem {
        @Override
        public void addTip(Skill skill, List<class_2561> tooltip) {tooltip.add(getTip(field_1060));}

        @Override
        public void tickSkill(Skill skill, class_1309 entity) {
            if (entity.method_37908() instanceof class_3218 world) {
                int cd = skill.getCD();
                if (world.method_8510() % 20 == 0 && cd == 1) { //确保一秒内只触发一次
                    draw(entity);
                    voice(entity, this);
                }
            }
        }

        @SkillInfo(trigger = {Trigger.LOSE_CARD_USE, Trigger.LOSE_CARD_DISCARD, Trigger.LOSE_CARD_MOVE}, relation = Relation.SELF)
        public int loseCard(class_1309 user, class_1309 target, Skill skill, ExData data) {
            if (user.method_29504()) return 0;
            var lostCards = data.cards_from_inv;
            if (!lostCards.isEmpty() && countCards(user) == 0) skill.setCD(5);
            return 0;
        }

        @SkillInfo(trigger = Trigger.ON_DEATH, relation = Relation.SELF)
        public int die(class_1309 user, class_1309 target, Skill skill, ExData data) {
            skill.setCD(0);
            return 0;
        }
    }

    public static class Liuli extends SkillItem {
        @Override
        public void addTip(Skill skill, List<class_2561> tooltip) {tooltip.add(getTip(field_1060));}

        @Override public boolean lockOn() {return true;}

        @SkillInfo(trigger = Trigger.DROP_TARGET, relation = Relation.NOT_SELF)
        public int beiSha(class_1309 user, class_1309 target, Skill skill, ExData data) {
            var targets = data.targets; var card = data.getFirst();
            if (isSha.test(card.toStack()) && targets.contains(user) && hasCard(user, isCard)) {
                class_1309 near = getClosestEntity(user, class_1309.class, 50, e -> e != target);
                if (near != null) {
                    targets.add(near);
                    data.removeTarget(user);
                    voice(user, this);
                    var d = d().cards(getCard(user, isCard), 1);
                    cardDiscard(user, d);
                }
            }
            return 0;
        }
    }

    public static class Pojun extends SkillItem {
        @Override
        public void addTip(Skill skill, List<class_2561> tooltip) {
            tooltip.add(class_2561.method_43470("CD: 10s"));
            tooltip.add(getTip(field_1060));
        }

        @Override
        public void preAttack(class_1657 player, class_1309 target, Skill skill) {
            //破军：攻击命中盔甲槽有物品的生物后，会让其所有盔甲掉落，配合古锭刀特效使用，pvp神器
            if (!player.method_6059(ModItems.COOLDOWN)) {
                for (var armor : target.method_5661()) {
                    if (armor.method_7960()) continue;
                    if (target instanceof class_1657 pl) {give(pl, armor.method_7972(), 100); armor.method_7939(0);}
                    else {target.method_5775(armor.method_7972()); armor.method_7939(0);}
                }
                voice(player, this);
                int i = target instanceof class_1657 ? 200 : 40;
                player.method_6092(new class_1293(ModItems.COOLDOWN, i,0, false,false,true));
            }
        }
    }

    public static class Qixi extends ConvertSkill {
        @Override
        public void addTip(Skill skill, List<class_2561> tooltip) {
            tooltip.add(getTip(field_1060));
        }

        @Override public boolean chooseEquipment() {return true;}
        @Override public Predicate<class_1799> getConvertFilter() {return isBlackCard;}
        @Override public CardItem convert(class_1799 stack) {return ModItems.DISCARD;}
    }

    public static class Shixin extends SkillItem {
        @Override
        public void addTip(Skill skill, List<class_2561> tooltip) {tooltip.add(getTip(field_1060));}

        @Override public boolean lockOn() {return true;}

        @SkillInfo(trigger = Trigger.CANCEL_DAMAGE_HIGH, relation = Relation.SELF)
        public int fanghuo(class_1309 user, class_1309 target, Skill skill, ExData data) {
            if (data.source.method_48789(class_8103.field_42246)) {
                if (skill.getCD() == 0) {voice(user, this); skill.setCD(10);}
                return 1;
            }
            return 0;
        }
    }

    public static class Xiaoji extends SkillItem {
        @Override
        public void addTip(Skill skill, List<class_2561> tooltip) {tooltip.add(getTip(field_1060));}

        @SkillInfo(trigger = {Trigger.LOSE_CARD_DISCARD, Trigger.LOSE_CARD_MOVE}, relation = Relation.SELF)
        public int loseEquip(class_1309 user, class_1309 target, Skill skill, ExData data) {
            var equips = data.cards_from_equ;
            if (user.method_5805() && !equips.isEmpty()) {
                voice(user, this);
                draw(user, 2 * equips.size());
            }
            return 0;
        }
    }

    public static class Yingzi extends SkillItem {
        public void addTip(Skill skill, List<class_2561> tooltip) {tooltip.add(getTip(field_1060));}

        @Override
        public int onDrawPhase(class_1657 player, Skill skill) {
            voice(player, this);
            return 1;
        }
    }

    public static class Zhiheng extends SkillItem {
        @Override
        public void addTip(Skill skill, List<class_2561> tooltip) {
            int cd = skill.getCD();
            tooltip.add(class_2561.method_43470(cd == 0 ? "CD: 30s" : "CD: 30s   left: "+ cd +"s"));
            tooltip.add(getTip("1", field_1060));
            tooltip.add(getTip("2", field_1060));
        }

        @Override public boolean isActiveSkill() {return true;}

        @Override
        public void addScreenTip(Skill skill, List<class_2561> tips) {
            addPresetTips(skill, tips, 0, 1, 2, 3, 4);
            super.addScreenTip(skill, tips);
        }

        @Override
        public boolean activeSkill(class_1657 user, Skill skill) {
            if (countAllCards(user) == 0) return false;
            int cd = skill.getCD();
            if (cd > 0) user.method_7353(class_2561.method_43471("dabaosword.cooldown").method_27692(field_1061), true);
            else {
                openInv(user, user, user, class_2561.method_43471("zhiheng.title"), skill.stack, true, false, 2);
                return true;
            }
            return false;
        }

        @Override
        public void onGuiClose(PlayerInvScreenHandler handler, class_1657 player, Skill skill, class_1657 target) {
            var num = handler.getSelectedCount();
            if (num == 0) return;
            voice(player, this);
            var data = handler.toExData(); var count = countCards(player);
            if (count != 0 && count == data.cards_from_inv.size()) num += 1;
            cardDiscard(player, data);
            draw(player, num);
            skill.setCD(30);
        }
    }

    public static class Zhijian extends SkillItem {
        @Override
        public void addTip(Skill skill, List<class_2561> tooltip) {
            tooltip.add(getTip("1", field_1060));
            tooltip.add(getTip("2", field_1060));
        }

        @Override public boolean isActiveSkill() {return true;}

        @Override
        public boolean activeSkill(class_1657 user, Skill skill, class_1309 target) {
            class_1799 itemStack = user.method_6047();
            if (isEquipment.test(itemStack)) {
                var data = d().cards(itemStack, 1);
                cardToEquip(user, data, target);
                voice(user, this);
                draw(user);
                return true;
            } else user.method_7353(class_2561.method_43471("zhijian.fail").method_27692(field_1061), true);
            return false;
        }
    }
}
