package com.amotassic.dabaosword.item.tool;

import java.util.List;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1667;
import net.minecraft.class_1685;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1814;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;

public class ArrowRainItem extends class_1792 {
    public ArrowRainItem() {super(new class_1793().method_7895(50).method_7894(class_1814.field_8907));}

    @Override
    public void method_7851(class_1799 stack, class_1937 world, List<class_2561> tooltip, class_1836 tooltipContext) {
        tooltip.add(class_2561.method_43471("item.dabaosword.wanjian.tooltip"));
    }

    //一次射五发
    @Override
    public class_1271<class_1799> method_7836(class_1937 world, class_1657 playerEntity, class_1268 hand) {
        class_1799 stack = playerEntity.method_5998(hand);
        if (!world.field_9236 && hand == class_1268.field_5808) {
            arrowRain(playerEntity, 5, 5);
            if (!playerEntity.method_7337()) stack.method_7956(1, playerEntity,player -> player.method_20235(class_1304.field_6173));
            return class_1271.method_22427(stack);
        }
        return class_1271.method_22430(stack);
    }

    public static void arrowRain(class_1309 entity, float speed, int count) {
        class_3218 world = (class_3218) entity.method_37908();
        for (int i = 0; i < count; i++) {
            int j;
            if (i % 2 == 0) j = -5 * i / 2; else j = 5 * (i + 1) / 2;
            summonArrow(entity, j, speed);
        }
        world.method_43128(null, entity.method_23317(), entity.method_23318(), entity.method_23321(), class_3417.field_14600, class_3419.field_15248, 1.0F, 1.0F / (world.method_8409().method_43057() * 0.4F + 1.2F) + 0.5F);
    }

    private static void summonArrow(class_1309 entity, int angle, float speed) {
        class_3218 world = (class_3218) entity.method_37908();
        class_1667 arrow = new class_1667(world, entity);
        arrow.method_5780("a");
        arrow.method_24919(entity, entity.method_36455(), entity.method_36454() + angle, 0.0F, speed, 1.0F);
        arrow.method_7439(true);
        world.method_8649(arrow);
    }

    //effect give @e[type=minecraft:iron_golem,limit=1,sort=nearest] dabaosword:cooldown2 1 4 true
    public static void arrowAround(class_1309 entity, float speed, int count, double radius, double height) {
        class_3218 world = (class_3218) entity.method_37908();
        for (int i = 0; i < count; i++) {
            // 计算角度
            float angle = (float) (i * (360.0 / count));
            // 将角度转换为弧度
            double radians = Math.toRadians(angle);
            // 计算箭的生成位置
            double xOffset = Math.cos(radians) * radius;
            double zOffset = Math.sin(radians) * radius;
            double x = entity.method_23317() + xOffset;
            double z = entity.method_23321() + zOffset;
            double y = entity.method_23318() + height;
            summonArrowToEntity(entity, x, y, z, speed);
        }
        world.method_43128(null, entity.method_23317(), entity.method_23318(), entity.method_23321(), class_3417.field_14600, class_3419.field_15248, 1.0F, 1.0F / (world.method_8409().method_43057() * 0.4F + 1.2F) + 0.5F);
    }

    private static void summonArrowToEntity(class_1309 target, double x, double y, double z, float speed) {
        class_3218 world = (class_3218) target.method_37908();
        class_1667 arrow = new class_1667(world, x, y, z);
        arrow.method_5780("cosmetic");
        // 计算箭的速度向量
        double dx = target.method_23317() - x;
        double dy = target.method_23318() + target.method_18381(target.method_18376()) - y;
        double dz = target.method_23321() - z;
        double distance = Math.sqrt(dx * dx + dy * dy + dz * dz);
        arrow.method_7485(dx / distance * speed, dy / distance * speed, dz / distance * speed, speed, 1.0F);
        arrow.method_7439(true);
        world.method_8649(arrow);
    }

    public static void tridentStorm(class_1309 entity, float speed, int count, double radius, double height) {
        class_3218 world = (class_3218) entity.method_37908();
        for (int i = 0; i < count; i++) {
            float angle = (float) (i * (360.0 / count));
            double radians = Math.toRadians(angle);
            double xOffset = Math.cos(radians) * radius;
            double zOffset = Math.sin(radians) * radius;
            double x = entity.method_23317() + xOffset;
            double z = entity.method_23321() + zOffset;
            double y = entity.method_23318() + height;
            summonTridentToEntity(entity, x, y, z, speed);
        }
        world.method_43128(null, entity.method_23317(), entity.method_23318(), entity.method_23321(), class_3417.field_15001, class_3419.field_15248, 1.0F, 1.0F / (world.method_8409().method_43057() * 0.4F + 1.2F) + 0.5F);
    }

    private static void summonTridentToEntity(class_1309 target, double x, double y, double z, float speed) {
        class_3218 world = (class_3218) target.method_37908();
        class_1685 trident = new class_1685(world, target, new class_1799(class_1802.field_8547));
        trident.method_5780("a");
        double dx = target.method_23317() - x;
        double dy = target.method_23318() + target.method_18381(target.method_18376()) - y;
        double dz = target.method_23321() - z;
        double distance = Math.sqrt(dx * dx + dy * dy + dz * dz);
        world.method_8649(trident);
        trident.method_7485(dx / distance * speed, dy / distance * speed, dz / distance * speed, speed, 1.0F);
        trident.method_7439(true);
        trident.method_24203(x, y, z);
    }
}
