package com.amotassic.dabaosword.mixin;

import com.amotassic.dabaosword.api.event.EndEntityTick;
import com.amotassic.dabaosword.api.event.EntityHurtCallback;
import com.amotassic.dabaosword.api.event.PlayerDeathCallback;
import com.amotassic.dabaosword.damage_type.ModDT;
import com.amotassic.dabaosword.item.ModItems;
import com.amotassic.dabaosword.util.ModTools;
import net.minecraft.class_1282;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1890;
import net.minecraft.class_1937;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(class_1657.class)
public abstract class PlayerEntityMixin extends class_1309 {
    protected PlayerEntityMixin(class_1299<? extends class_1309> entityType, class_1937 world) {super(entityType, world);}

    @Shadow public abstract class_1799 method_6118(class_1304 slot);

    @Unique class_1657 player = (class_1657) (Object) this;

    @Inject(at = @At("TAIL"), method = "tick")
    public void tick(CallbackInfo ci) {
        if (this.method_5752().contains("px")) this.field_6273 = 1145;
        EndEntityTick.PLAYER_EVENT.invoker().endPlayerTick(player);
    }

    @Inject(at = @At("TAIL"), method = "applyDamage")
    private void onEntityHurt(final class_1282 source, final float amount, CallbackInfo ci) {
        EntityHurtCallback.EVENT.invoker().hurtEntity(player, source, amount);
    }

    @ModifyVariable(method = "attack", at = @At(value = "STORE"), ordinal = 2)
    public boolean attack(boolean bl) {
        boolean crit = class_1890.method_8225(ModItems.CRIT, method_6118(class_1304.field_6169)) > 0;
        return bl || crit;
    }

    @Inject(method = "getHurtSound", at = @At("RETURN"), cancellable = true)
    protected void getHurtSound(class_1282 source, CallbackInfoReturnable<class_3414> cir) {
        if (source.method_49708(ModDT.LOSEHP)) cir.setReturnValue(ModTools.getSound("dabaosword", "losehp"));
    }

/*    @Unique boolean fly = ClientTickEnd.clientFly;

    @Inject(method = "checkFallFlying", at = @At("HEAD"), cancellable = true)
    public void checkGliding(CallbackInfoReturnable<Boolean> cir) {
        if (fly) cir.setReturnValue(false);
    }

    @Inject(method = "getOffGroundSpeed", at = @At("HEAD"), cancellable = true)
    protected void getOffGroundSpeed(CallbackInfoReturnable<Float> cir) {
        if (fly) cir.setReturnValue(this.isSprinting() ? this.abilities.getFlySpeed() * 2.0F : this.abilities.getFlySpeed());
    }*/
}

@Mixin(class_3222.class)
abstract class ServerPlayerEntityMixin extends PlayerEntityMixin {
    protected ServerPlayerEntityMixin(class_1299<? extends class_1309> entityType, class_1937 world) {
        super(entityType, world);
    }

    @Inject(method = "onDeath", at = @At("HEAD"))
    public void onDeath(class_1282 damageSource, CallbackInfo callbackInfo) {
        PlayerDeathCallback.EVENT.invoker().onDeath(((class_3222) (Object) this), damageSource);
    }

}
