package com.amotassic.dabaosword.mixin.client;

import com.amotassic.dabaosword.item.ModItems;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import java.util.Objects;
import net.minecraft.class_1309;
import net.minecraft.class_2561;
import net.minecraft.class_922;

@Mixin(class_922.class)
public abstract class LivingEntityRendererMixin {

    @Inject(method = "shouldFlipUpsideDown", at = @At("TAIL"), cancellable = true)
    private static void shouldFlipUpsideDown(class_1309 entity, CallbackInfoReturnable<Boolean> cir) {
        //如果生物有翻面效果，生物的模型会上下翻转，就像Dinnerbone一样
        if (entity.method_6059(ModItems.TURNOVER)) cir.setReturnValue(true);
        if (Objects.equals(entity.method_5797(), class_2561.method_43470("翻面"))) cir.setReturnValue(true);
    }
}
