package com.amotassic.dabaosword.ui;

import com.amotassic.dabaosword.api.CardPileInventory;
import com.amotassic.dabaosword.event.PVPGameEvents;
import com.amotassic.dabaosword.item.ModItems;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1713;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_3222;

import static com.amotassic.dabaosword.api.CardEvents.cardDiscard;
import static com.amotassic.dabaosword.util.ModTools.*;

public class PileScreenHandler extends class_1703 {
    private final CardPileInventory inventory;

    public PileScreenHandler(int syncId, class_1661 inv, class_2540 buf) {
        this(syncId, inv);
    }

    public PileScreenHandler(int syncId, class_1661 inv) {
        super(ModItems.PILE_SCREEN_HANDLER, syncId);
        this.inventory = new CardPileInventory(inv.field_7546);
        if (inv.field_7546 instanceof class_3222 sp) PVPGameEvents.PLAYER_CARD_PACKS.put(sp, inventory);
        inventory.method_5435(inv.field_7546);
        int j, k;
        for (j = 0; j < 4; ++j) {
            for (k = 0; k < 9; ++k) {
                this.method_7621(new PileSlot(inventory, k + j * 9, 8 + k * 18, 18 + j * 18));
            }
        }
        for (j = 0; j < 3; ++j) {
            for (k = 0; k < 9; ++k) {
                this.method_7621(new class_1735(inv, k + j * 9 + 9, 8 + k * 18, 103 + j * 18));
            }
        }
        for (j = 0; j < 9; ++j) {
            this.method_7621(new class_1735(inv, j, 8 + j * 18, 161));
        }
    }

    @Override
    public void method_7595(class_1657 player) {
        super.method_7595(player);
        this.inventory.method_5432(player);
    }

    @Override
    public boolean method_7597(class_1657 player) {
        return true;
    }

    @Override
    public class_1799 method_7601(class_1657 player, int slot) {
        class_1799 itemStack = class_1799.field_8037;
        class_1735 slot2 = this.field_7761.get(slot);
        if (slot2.method_7681()) {
            class_1799 itemStack2 = slot2.method_7677();
            itemStack = itemStack2.method_7972();
            if (slot < 36 ? !this.method_7616(itemStack2, 4 * 9, this.field_7761.size(), true) : !this.method_7616(itemStack2, 0, 4 * 9, false)) {
                return class_1799.field_8037;
            }
            if (itemStack2.method_7960()) {
                slot2.method_48931(class_1799.field_8037);
            } else {
                slot2.method_7668();
            }
        }
        return itemStack;
    }

    @Override
    public void method_7593(int slotIndex, int button, class_1713 actionType, class_1657 player) {
        if (button == 261 && !player.method_37908().field_9236) {
            class_1799 pile = trinketItem(ModItems.CARD_PILE, player);
            class_2487 nbt = pile.method_7948();
            int dropped = nbt.method_10550("DroppedCards");
            class_1799 stack = method_7611(slotIndex).method_7677();
            if (isCard(stack)) { //按下delete键后丢弃卡片，当丢弃3张卡片后，摸一张牌
                cardDiscard(player, d().cards(stack, 1));
                if (dropped == 2) {
                    nbt.method_10551("DroppedCards");
                    draw(player);
                } else nbt.method_10569("DroppedCards", dropped + 1);
                pile.method_7980(nbt);
            }
            return;
        }
        super.method_7593(slotIndex, button, actionType, player);
    }

    private static class PileSlot extends class_1735 {
        public PileSlot(class_1263 inventory, int index, int x, int y) {
            super(inventory, index, x, y);
        }

        @Override
        public boolean method_7680(class_1799 stack) {return isCard(stack);}
    }
}
