package com.amotassic.dabaosword.util;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.class_1277;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2371;

import static com.amotassic.dabaosword.util.ModTools.*;

import com.amotassic.dabaosword.api.CardPileInventory;

public class TempInventory extends class_1277 {
    public final class_1657 user;
    public final class_1309 owner;
    public final int type;
    public final Set<Integer> rowsToShow = new HashSet<>();

    public TempInventory(class_1657 user, class_1799 eventStack, List<class_1799> stacks) {
        this(user, user, eventStack, 0, false, false);
        for (var stack : stacks) {
            int index = stacks.indexOf(stack);
            if (index < 81) method_5447(index, stack);
        }

        for (int i = 0; i < 9; i++) {
            for (int j = 0; j < 9; j++) {
                int index = i * 9 + j;
                if (!method_5438(index).method_7960()) {rowsToShow.add(i); break;}
            }
        }
    }

    /**
     @param equip: 是否显示装备牌
     @param armor: 是否显示玩家的盔甲
     @param type: 是否显示手牌。0：完全不显示；1：仅展示牌背；2：显示所有手牌；3：显示所有物品
     */
    public TempInventory(class_1657 user, class_1309 owner, class_1799 eventStack, int type, boolean equip, boolean armor) {
        super(90);
        this.user = user; this.owner = owner;
        method_5447(81, eventStack);
        this.type = type;

        if (equip) for (var stack : allTrinkets(owner)) {
            if (stack.method_31573(Tags.WEAPON)) method_5447(0, stack);
            if (stack.method_31573(Tags.ARMOR)) method_5447(1, stack);
            if (stack.method_31573(Tags.DEFEND)) method_5447(2, stack);
            if (stack.method_31573(Tags.ATTACK)) method_5447(3, stack);
        } //四件装备占1~4格

        var armors = owner.method_5661(); int armorIndex = 0;
        if (armor) for (class_1799 stack : armors) {
            method_5447(7 - armorIndex, stack); armorIndex++;
        } //4件盔甲占5~8格

        var off = owner.method_6079(); //副手占9格
        if (shouldAdd(type, off)) method_5447(8, off);

        boolean bl = type == 1;
        if (owner instanceof class_1657 pl) {
            var inv = pl.method_31548().field_7547; //背包占2,3,4,5行
            for (var s : inv) if (shouldAdd(type, s)) method_5447(9 + inv.indexOf(s), bl ? paibei(s.method_7947()) : s);
            var pack = getCardPack(pl); var cards = pack.cards;
            if (!pack.method_5442()) { //手牌背包的卡牌占6,7,8,9行
                for (var s : cards) if (shouldAdd(type, s)) method_5447(45 + cards.indexOf(s), bl ? paibei(s.method_7947()) : s);
            }
        } else { //不是玩家的话就只有主副手
            var main = owner.method_6047();
            if (shouldAdd(type, main)) method_5447(9, main);
        }

        for (int i = 0; i < 9; i++) {
            for (int j = 0; j < 9; j++) {
                int index = i * 9 + j;
                if (!method_5438(index).method_7960()) {rowsToShow.add(i); break;}
            }
        }
    }

    boolean shouldAdd(int type, class_1799 stack) {
        if (type == 3) return true;
        return (type == 1 || type == 2) && isCard(stack);
    }
}
