/*
 * Decompiled with CFR 0.152.
 */
package com.amotassic.dabaosword.api.card;

import com.amotassic.dabaosword.api.card.Rank;
import com.amotassic.dabaosword.api.card.Suit;
import com.amotassic.dabaosword.item.ModItems;
import com.amotassic.dabaosword.item.card.CardItem;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2487;
import net.minecraft.class_2561;

public final class Card {
    private final class_1799 card;
    private final class_1799 copy;
    private final CardItem item;
    public final int type;
    public final Suit suit;
    public final Rank rank;
    public int count;
    public static final int BASIC = 0;
    public static final int ARMOURY = 1;
    public static final int EQUIPMENT = 2;

    public Card(CardItem item, Suit suit, Rank rank) {
        this.card = this.copy = class_1799.field_8037;
        this.item = item;
        this.type = item.getType();
        this.suit = suit;
        this.rank = rank;
        this.count = 1;
    }

    public Card(CardItem item) {
        this(item, Suit.None, Rank.None);
    }

    public Card(class_1799 card) {
        CardItem c;
        this.card = card;
        this.copy = card.method_7972();
        class_1792 class_17922 = card.method_7909();
        this.item = class_17922 instanceof CardItem ? (c = (CardItem)class_17922) : ModItems.EMPTY_CARD;
        this.type = this.item.getType();
        this.count = card.method_7947();
        class_2487 nbt = card.method_7948();
        this.suit = this.count == 0 ? Suit.None : Suit.fromNbt(nbt);
        this.rank = this.count == 0 ? Rank.None : Rank.fromNbt(nbt);
    }

    public CardItem item() {
        return this.item;
    }

    public boolean isFromStack() {
        return !this.copy.method_7960();
    }

    public class_1799 origin() {
        return this.card;
    }

    public class_1799 toStack() {
        if (this.isFromStack()) {
            return this.copy.method_7972();
        }
        class_1799 stack = new class_1799((class_1935)this.item, this.count);
        class_2487 nbt = new class_2487();
        if (this.suit != Suit.None) {
            nbt.method_10582("Suit", this.suit.name());
        }
        if (this.rank != Rank.None) {
            nbt.method_10582("Rank", this.rank.rank);
        }
        stack.method_7980(nbt);
        return stack;
    }

    public boolean askForWuxie() {
        CardItem cardItem = this.item;
        if (cardItem instanceof CardItem.Armoury) {
            CardItem.Armoury a = (CardItem.Armoury)cardItem;
            return a.askForWuxie();
        }
        return false;
    }

    public void effect(class_1309 user, class_1799 card, class_1309 target) {
        this.item.effect(user, card, target);
    }

    public boolean isOf(class_1792 item) {
        return this.item == item;
    }

    public class_2561 getName() {
        return this.item.method_7848();
    }

    public String toString() {
        return this.card + ", suit=" + this.suit + ", rank=" + this.rank;
    }
}

