/*
 * Decompiled with CFR 0.152.
 */
package com.amotassic.dabaosword.util;

import com.amotassic.dabaosword.DabaoSword;
import com.amotassic.dabaosword.api.CardPileInventory;
import com.amotassic.dabaosword.api.card.Card;
import com.amotassic.dabaosword.api.card.Suit;
import com.amotassic.dabaosword.api.skill.ExData;
import com.amotassic.dabaosword.api.skill.ISkill;
import com.amotassic.dabaosword.api.skill.Skill;
import com.amotassic.dabaosword.api.skill.SkillExecutor;
import com.amotassic.dabaosword.api.skill.Trigger;
import com.amotassic.dabaosword.data.CardSuitAndRank;
import com.amotassic.dabaosword.event.PVPGameEvents;
import com.amotassic.dabaosword.item.ModItems;
import com.amotassic.dabaosword.item.card.CardItem;
import com.amotassic.dabaosword.item.card.Sha;
import com.amotassic.dabaosword.item.skillcard.SkillItem;
import com.amotassic.dabaosword.ui.FullInvScreenHandler;
import com.amotassic.dabaosword.ui.PlayerInvScreenHandler;
import com.amotassic.dabaosword.util.TempInventory;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.ParseResults;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import dev.emi.trinkets.api.TrinketInventory;
import dev.emi.trinkets.api.TrinketsApi;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectListIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.function.Predicate;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.minecraft.class_1268;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_173;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_238;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3545;
import net.minecraft.class_3908;
import net.minecraft.class_52;
import net.minecraft.class_5321;
import net.minecraft.class_5819;
import net.minecraft.class_5903;
import net.minecraft.class_5904;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_8110;
import net.minecraft.class_8567;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModTools {
    public static final Predicate<class_1799> canSaveDying = ModTools.p(ModItems.JIU).or(ModTools.p(ModItems.PEACH));
    public static final Predicate<class_1799> isSha = s -> s.method_7909() instanceof Sha;
    public static final Predicate<class_1799> isCard = ModTools::isCard;
    public static final Predicate<class_1799> isBasic = s -> ModTools.c((class_1799)s).type == 0;
    public static final Predicate<class_1799> isArmoury = s -> ModTools.c((class_1799)s).type == 1;
    public static final Predicate<class_1799> isEquipment = s -> ModTools.c((class_1799)s).type == 2;
    public static final Predicate<class_1799> isDiamondCard = s -> ModTools.c((class_1799)s).suit == Suit.Diamond;
    public static final Predicate<class_1799> isHeartCard = s -> ModTools.c((class_1799)s).suit == Suit.Heart;
    public static final Predicate<class_1799> isClubCard = s -> ModTools.c((class_1799)s).suit == Suit.Club;
    public static final Predicate<class_1799> isSpadeCard = s -> ModTools.c((class_1799)s).suit == Suit.Spade;
    public static final Predicate<class_1799> isRedCard = isDiamondCard.or(isHeartCard);
    public static final Predicate<class_1799> isBlackCard = isClubCard.or(isSpadeCard);
    private static final List<class_1799> CARD_PILE = new ArrayList<class_1799>();

    public static Card c(class_1799 card) {
        return new Card(card);
    }

    public static Card c(class_1799 card, CardItem replace) {
        Card c = ModTools.c(card);
        return new Card(replace, c.suit, c.rank);
    }

    public static Skill s(class_1799 skill) {
        return new Skill(skill);
    }

    public static ExData d() {
        return new ExData();
    }

    public static Predicate<class_1799> p(class_1792 item) {
        return s -> s.method_31574(item);
    }

    public static boolean isCard(class_1799 s) {
        return s.method_7909() instanceof CardItem;
    }

    @SafeVarargs
    public static <T> List<T> toList(T ... t) {
        return new ArrayList<T>(Arrays.asList(t));
    }

    public static boolean hasTrinket(class_1792 item, class_1309 entity) {
        return ModTools.isEquipped(entity, ModTools.p(item));
    }

    public static boolean isEquipped(class_1309 entity, Predicate<class_1799> p) {
        return TrinketsApi.getTrinketComponent((class_1309)entity).map(c -> c.isEquipped(p)).orElse(false);
    }

    public static class_1799 trinketItem(class_1792 item, class_1309 entity) {
        return TrinketsApi.getTrinketComponent((class_1309)entity).map(c -> c.getEquipped(item).stream().map(class_3545::method_15441).findFirst().orElse(class_1799.field_8037)).orElse(class_1799.field_8037);
    }

    public static List<class_1799> allTrinkets(class_1309 entity) {
        return TrinketsApi.getTrinketComponent((class_1309)entity).map(c -> c.getAllEquipped().stream().map(class_3545::method_15441).toList()).orElse(Collections.emptyList());
    }

    public static List<class_3545<TrinketInventory, Integer>> trinketsWithSlots(class_1309 entity) {
        return ModTools.trinketsWithSlots(entity, s -> true);
    }

    public static List<class_3545<TrinketInventory, Integer>> trinketsWithSlots(class_1309 entity, Predicate<class_1799> filter) {
        ArrayList<class_3545<TrinketInventory, Integer>> pairs = new ArrayList<class_3545<TrinketInventory, Integer>>();
        TrinketsApi.getTrinketComponent((class_1309)entity).ifPresent(c -> c.getInventory().values().forEach(group -> group.values().forEach(inv -> {
            for (int i = 0; i < inv.method_5439(); ++i) {
                if (!filter.test(inv.method_5438(i))) continue;
                pairs.add(new class_3545(inv, (Object)i));
            }
        })));
        return pairs;
    }

    public static void replaceTrinketSlot(List<class_3545<TrinketInventory, Integer>> pairs, int slot) {
        int i;
        if (slot < 1 || slot >= pairs.size()) {
            return;
        }
        ArrayList<class_1799> copys = new ArrayList<class_1799>(pairs.stream().map(p -> ((TrinketInventory)p.method_15442()).method_5438(((Integer)p.method_15441()).intValue()).method_7972()).toList());
        class_1799 stack = ((class_1799)copys.get(slot)).method_7972();
        for (i = slot; i > 0; --i) {
            copys.set(i, (class_1799)copys.get(i - 1));
        }
        copys.set(0, stack);
        for (i = 0; i < pairs.size(); ++i) {
            ((TrinketInventory)pairs.get(i).method_15442()).method_5447(((Integer)pairs.get(i).method_15441()).intValue(), (class_1799)copys.get(i));
        }
    }

    public static CardPileInventory getCardPack(class_1657 player) {
        if (player instanceof class_3222) {
            class_3222 sp = (class_3222)player;
            return PVPGameEvents.PLAYER_CARD_PACKS.getOrDefault(sp, new CardPileInventory(player));
        }
        return new CardPileInventory(player);
    }

    public static boolean shouldReachLong(class_1309 entity) {
        for (class_1268 hand : class_1268.values()) {
            CardItem c;
            class_1792 class_17922 = entity.method_5998(hand).method_7909();
            if (!(class_17922 instanceof CardItem) || !(c = (CardItem)class_17922).rangedUse()) continue;
            return true;
        }
        return false;
    }

    public static boolean hasCard(class_1309 entity, Predicate<class_1799> predicate) {
        return !ModTools.getCard(entity, predicate).method_7960();
    }

    public static class_1799 getCard(class_1309 entity, Predicate<class_1799> predicate) {
        if (entity instanceof class_1657) {
            class_1657 player = (class_1657)entity;
            for (class_1799 card : ModTools.getCardPack((class_1657)player).cards) {
                if (!predicate.test(card)) continue;
                return card;
            }
        }
        return ModTools.getItem(entity, predicate);
    }

    public static boolean hasItem(@NotNull class_1309 entity, Predicate<class_1799> predicate) {
        return !ModTools.getItem(entity, predicate).method_7960();
    }

    public static class_1799 getItem(@NotNull class_1309 entity, Predicate<class_1799> predicate) {
        if (entity instanceof class_1657) {
            class_1657 player = (class_1657)entity;
            for (class_1799 stack : player.method_31548().field_7547) {
                if (!predicate.test(stack)) continue;
                return stack;
            }
        } else if (predicate.test(entity.method_6047())) {
            return entity.method_6047();
        }
        if (predicate.test(entity.method_6079())) {
            return entity.method_6079();
        }
        return class_1799.field_8037;
    }

    public static void voice(class_1309 entity, class_3414 sound, float ... volume) {
        class_1937 class_19372 = entity.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 world = (class_3218)class_19372;
            float v = volume.length > 0 ? volume[0] : 2.0f;
            world.method_8449(null, (class_1297)entity, class_6880.method_40223((Object)sound), class_3419.field_15248, v, 1.0f, class_5819.method_43047().method_43055());
        }
    }

    public static void voice(class_1309 entity, class_1792 item, float ... volume) {
        ModTools.voice(entity, item.toString(), volume);
    }

    public static void voice(class_1309 entity, class_1799 stack, float ... volume) {
        ModTools.voice(entity, stack.method_7909(), volume);
    }

    public static void voice(class_1309 entity, String name, float ... volume) {
        ModTools.voice(entity, ModTools.getSound("dabaosword", name), volume);
    }

    public static class_3414 getSound(String namespace, String path) {
        return (class_3414)class_6880.method_40223((Object)class_3414.method_47908((class_2960)new class_2960(namespace, path))).comp_349();
    }

    public static int countCards(class_1309 entity) {
        return ModTools.countCard(entity, isCard);
    }

    public static int countAllCards(class_1309 entity) {
        return ModTools.count(entity, isCard, false, true, true);
    }

    public static int countCard(class_1309 entity, Predicate<class_1799> predicate) {
        return ModTools.count(entity, predicate, false, true, false);
    }

    public static int count(class_1309 entity, Predicate<class_1799> predicate, boolean armor, boolean pile, boolean trinkets) {
        int n = 0;
        for (class_1799 stack : ModTools.getItems(entity, predicate, true, armor, trinkets, pile)) {
            n += stack.method_7947();
        }
        return n;
    }

    public static List<class_1799> getItems(class_1309 entity, Predicate<class_1799> p, boolean main, boolean armor, boolean trinket, boolean pile) {
        class_1657 player;
        ArrayList<class_1799> items = new ArrayList<class_1799>();
        if (pile && entity instanceof class_1657) {
            player = (class_1657)entity;
            for (class_1799 stack : ModTools.getCardPack((class_1657)player).cards) {
                if (!p.test(stack)) continue;
                items.add(stack);
            }
        }
        if (main) {
            if (entity instanceof class_1657) {
                player = (class_1657)entity;
                for (class_1799 stack : player.method_31548().field_7547) {
                    if (!p.test(stack)) continue;
                    items.add(stack);
                }
            } else if (p.test(entity.method_6047())) {
                items.add(entity.method_6047());
            }
            if (p.test(entity.method_6079())) {
                items.add(entity.method_6079());
            }
        }
        if (armor) {
            for (class_1799 stack : entity.method_5661()) {
                if (!p.test(stack)) continue;
                items.add(stack);
            }
        }
        if (trinket) {
            for (class_1799 stack : ModTools.allTrinkets(entity)) {
                if (!p.test(stack)) continue;
                items.add(stack);
            }
        }
        return items;
    }

    public static void draw(class_1309 entity, int ... count) {
        int num = count.length > 0 ? count[0] : 1;
        for (int n = 0; n < num; ++n) {
            if (entity.method_6059(ModItems.BINGLIANG)) {
                int amplifier = Objects.requireNonNull(entity.method_6112(ModItems.BINGLIANG)).method_5578();
                entity.method_6016(ModItems.BINGLIANG);
                ModTools.voice(entity, class_3417.field_15008, 1.0f);
                if (amplifier == 0) continue;
                entity.method_6092(new class_1293(ModItems.BINGLIANG, -1, amplifier - 1));
                continue;
            }
            ModTools.give(entity, ModTools.newCard(), new int[0]);
            ModTools.voice(entity, class_3417.field_14627, 1.0f);
        }
    }

    public static class_1799 customLoot(class_1309 entity, String path) {
        class_8567 set;
        class_52 lt = Objects.requireNonNull(entity.method_37908().method_8503()).method_3857().getLootTable(new class_2960("dabaosword", path));
        ObjectArrayList list = lt.method_51878(set = new class_8567.class_8568((class_3218)entity.method_37908()).method_51874(class_181.field_24424, (Object)entity.method_19538()).method_51874(class_181.field_1226, (Object)entity).method_51875(class_173.field_16235));
        ObjectListIterator objectListIterator = list.iterator();
        if (objectListIterator.hasNext()) {
            class_1799 stack = (class_1799)objectListIterator.next();
            return stack;
        }
        return class_1799.field_8037;
    }

    public static class_1799 newCard() {
        if (CARD_PILE.isEmpty()) {
            for (class_1799 stack : CardSuitAndRank.ALL_CARDS) {
                CARD_PILE.add(stack.method_7972());
            }
            Collections.shuffle(CARD_PILE);
            DabaoSword.LOGGER.info("Shuffled card pile");
        }
        return CARD_PILE.remove(0);
    }

    public static class_1799 newCard(class_1792 item) {
        return ModTools.newCard(ModTools.p(item));
    }

    public static class_1799 newCard(Predicate<class_1799> predicate) {
        List<class_1799> list = CardSuitAndRank.ALL_CARDS.stream().filter(predicate).toList();
        if (list.isEmpty()) {
            return class_1799.field_8037;
        }
        return list.get(new Random().nextInt(list.size())).method_7972();
    }

    public static void give(class_1309 entity, class_1799 stack, int ... pickupDelay) {
        if (entity instanceof class_1657) {
            class_1657 player = (class_1657)entity;
            class_1542 item = player.method_7328(stack, false);
            if (item == null) {
                return;
            }
            item.method_5684(true);
            int delay = pickupDelay.length > 0 ? pickupDelay[0] : 0;
            item.method_6982(delay);
            item.method_48349(player.method_5667());
            item.method_5780("follow_owner");
            return;
        }
        if (entity.method_6047().method_7960()) {
            entity.method_6122(class_1268.field_5808, stack);
        } else if (entity.method_6079().method_7960()) {
            entity.method_6122(class_1268.field_5810, stack);
        }
    }

    @Nullable
    public static <T extends class_1297> T getClosestEntity(class_1297 entity, Class<T> clazz, double boxLength, Predicate<T> predicate) {
        class_238 box;
        class_3218 world;
        List entities;
        class_1937 class_19372 = entity.method_37908();
        if (class_19372 instanceof class_3218 && !(entities = (world = (class_3218)class_19372).method_8390(clazz, box = new class_238(entity.method_24515()).method_1014(boxLength), predicate.and(e -> e != entity))).isEmpty()) {
            HashMap<Float, class_1297> map = new HashMap<Float, class_1297>();
            for (class_1297 e2 : entities) {
                map.put(Float.valueOf(e2.method_5739(entity)), e2);
            }
            float min = ((Float)Collections.min(map.keySet())).floatValue();
            return (T)((class_1297)map.get(Float.valueOf(min)));
        }
        return null;
    }

    public static void openFullInv(class_1657 player, final class_1309 target, final boolean editable) {
        if (player.method_37908().field_9236) {
            return;
        }
        player.method_17355((class_3908)new ExtendedScreenHandlerFactory(){

            public class_2561 method_5476() {
                return target.method_5476();
            }

            public void writeScreenOpeningData(class_3222 player, class_2540 buf) {
                buf.writeInt(target.method_5628());
                buf.writeBoolean(editable);
            }

            public class_1703 createMenu(int syncId, class_1661 inv, class_1657 player) {
                class_2540 buf = PacketByteBufs.create();
                buf.writeInt(target.method_5628());
                buf.writeBoolean(editable);
                return new FullInvScreenHandler(syncId, inv, buf);
            }
        });
    }

    public static void openInv(class_1657 player, class_1309 owner, final class_1657 target, final class_2561 title, class_1799 stack, boolean equip, boolean armor, int cards) {
        if (player.method_37908().field_9236) {
            return;
        }
        final TempInventory tempInv = new TempInventory(player, owner, stack, cards, equip, armor);
        final Set<Integer> rows = tempInv.rowsToShow;
        player.method_17355((class_3908)new ExtendedScreenHandlerFactory(){

            public void writeScreenOpeningData(class_3222 player, class_2540 buf) {
                buf.writeInt(target.method_5628());
                buf.method_10814(rows.toString());
            }

            public class_2561 method_5476() {
                return title;
            }

            @NotNull
            public class_1703 createMenu(int syncId, class_1661 inv, class_1657 player) {
                return new PlayerInvScreenHandler(syncId, tempInv, target, rows);
            }
        });
    }

    public static void openMenu(class_1657 player, final class_1657 target, class_1799 stack, List<class_1799> stacks, final class_2561 title) {
        if (player.method_37908().field_9236) {
            return;
        }
        final TempInventory tempInv = new TempInventory(player, stack, stacks);
        final Set<Integer> rows = tempInv.rowsToShow;
        player.method_17355((class_3908)new ExtendedScreenHandlerFactory(){

            public class_2561 method_5476() {
                return title;
            }

            public void writeScreenOpeningData(class_3222 player, class_2540 buf) {
                buf.writeInt(target.method_5628());
                buf.method_10814(rows.toString());
            }

            public class_1703 createMenu(int syncId, class_1661 playerInventory, class_1657 player) {
                return new PlayerInvScreenHandler(syncId, tempInv, target, rows);
            }
        });
    }

    public static class_1799 paibei(int ... n) {
        return new class_1799((class_1935)ModItems.GAIN_CARD, n.length > 0 ? n[0] : 1);
    }

    public static void closeGUI(class_1657 player) {
        player.method_6092(new class_1293(ModItems.COOLDOWN2, 1, 2, false, false, false));
    }

    public static class_1282 damageSource(class_1297 source, class_5321<class_8110> type) {
        return new class_1282((class_6880)source.method_37908().method_30349().method_30530(class_7924.field_42534).method_40290(type), source);
    }

    public static void writeDamage(class_1282 source, float amount, boolean returnShan, class_1799 stack) {
        class_2499 list = new class_2499();
        class_2487 compound = new class_2487();
        compound.method_10582("type", ((class_5321)source.method_48793().method_40230().get()).method_29177().toString());
        if (source.method_5526() != null) {
            compound.method_10569("source", source.method_5526().method_5628());
        }
        if (source.method_5529() != null) {
            compound.method_10569("attacker", source.method_5529().method_5628());
        }
        compound.method_10548("amount", amount);
        if (returnShan) {
            compound.method_10582("returning", "dabaosword:shan");
        }
        list.add((Object)compound);
        class_2487 nbt = stack.method_7948();
        nbt.method_10566("DamageDodged", (class_2520)list);
        stack.method_7980(nbt);
    }

    public static class_3545<class_3545<class_1282, Float>, class_1799> getDamage(class_1657 player) {
        class_1937 class_19372 = player.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 world = (class_3218)class_19372;
            class_1799 stack = ModTools.trinketItem(ModItems.CARD_PILE, (class_1309)player);
            class_2487 compound = stack.method_7948();
            if (compound.method_10545("DamageDodged")) {
                class_2487 nbt = ((class_2499)Objects.requireNonNull(compound.method_10580("DamageDodged"))).method_10602(0);
                class_5321 type = class_5321.method_29179((class_5321)class_7924.field_42534, (class_2960)new class_2960(nbt.method_10558("type")));
                class_6880.class_6883 entry = world.method_30349().method_30530(class_7924.field_42534).method_40290(type);
                class_1297 source = world.method_8469(nbt.method_10550("source"));
                class_1297 attacker = world.method_8469(nbt.method_10550("attacker"));
                class_1282 damageSource = new class_1282((class_6880)entry, source, attacker);
                class_1799 returning = class_1799.field_8037;
                if (nbt.method_10545("returning")) {
                    returning = new class_1799((class_1935)class_7923.field_41178.method_10223(new class_2960(nbt.method_10558("returning"))));
                }
                float amount = nbt.method_10583("amount");
                return new class_3545((Object)new class_3545((Object)damageSource, (Object)Float.valueOf(amount)), (Object)returning);
            }
        }
        return null;
    }

    public static void excuteServerCommand(class_1297 entity, String ... commands) {
        class_1937 class_19372 = entity.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 world = (class_3218)class_19372;
            MinecraftServer server = world.method_8503();
            CommandDispatcher dispatcher = server.method_3734().method_9235();
            class_2168 commandSource = entity.method_5671().method_9206(2).method_9217();
            for (String command : commands) {
                if (command.startsWith("/")) {
                    command = command.substring(1);
                }
                try {
                    ParseResults results = dispatcher.parse(command, (Object)commandSource);
                    dispatcher.execute(results);
                }
                catch (CommandSyntaxException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    public static void title(class_3222 player, class_2561 title) {
        player.field_13987.method_14364((class_2596)new class_5904(title));
    }

    public static void subtitle(class_3222 player, class_2561 sub) {
        player.field_13987.method_14364((class_2596)new class_5903(sub));
    }

    public static List<class_1309> getSkillOwners(class_1309 entity) {
        if (entity.method_37908().field_9236) {
            return List.of();
        }
        return new ArrayList<class_1309>(Objects.requireNonNull(entity.method_5682()).method_3760().method_14571());
    }

    public static List<Skill> getSkillsMayUse(class_1309 entity) {
        Predicate<class_1799> p = s -> {
            if (!(s.method_7909() instanceof ISkill)) {
                return false;
            }
            if (s.method_7909() instanceof SkillItem && entity.method_5752().contains("duanchang")) {
                return false;
            }
            return ModTools.s(s).lockOn() || !entity.method_6059(ModItems.TIEJI);
        };
        return TrinketsApi.getTrinketComponent((class_1309)entity).map(c -> c.getEquipped(p).stream().map(class_3545::method_15441).map(Skill::new).toList()).orElse(Collections.emptyList());
    }

    public static int getResult(Trigger t, class_1309 owner, class_1309 triggered, ExData exData) {
        for (Skill skill : ModTools.getSkillsMayUse(owner)) {
            for (SkillExecutor data : skill.data()) {
                int i;
                if (!List.of(data.trigger()).contains((Object)t) || !data.relation().test(owner, triggered, exData.source) || (i = data.apply(owner, triggered, skill, exData)) <= 0) continue;
                return i;
            }
        }
        return 0;
    }

    public static String getTagValue(class_1297 entity, String name) {
        return entity.method_5752().stream().filter(s -> s.startsWith(name + "_")).findFirst().map(s -> s.split("_")[1]).orElse("");
    }

    public static int getTagCount(class_1297 entity, String name) {
        return entity.method_5752().stream().filter(s -> s.startsWith(name + "_")).findFirst().map(s -> Integer.parseInt(s.split("_")[1])).orElse(0);
    }

    public static boolean hasTag(class_1297 entity, String name) {
        return entity.method_5752().stream().anyMatch(s -> s.startsWith(name));
    }

    public static void removeTag(class_1297 entity, String name) {
        Iterator each = entity.method_5752().iterator();
        while (each.hasNext()) {
            if (!((String)each.next()).startsWith(name)) continue;
            each.remove();
            break;
        }
    }

    public static void addTag(class_1297 entity, String name, int n) {
        ModTools.removeTag(entity, name);
        entity.method_5780(name + "_" + n);
    }

    public static void addTag(class_1297 entity, String name, String suffix) {
        entity.method_5780(name + "_" + suffix);
    }
}

