/*
 * Decompiled with CFR 0.152.
 */
package net.xun.lib.common.api.inventory;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.xun.lib.common.api.inventory.slot.SlotRange;
import net.xun.lib.common.api.util.InventoryUtils;
import org.jetbrains.annotations.Nullable;

public enum InventoryCycleOrder {
    FORWARD,
    REVERSE,
    PLAYER_PRIORITY,
    ARMOR_FIRST;


    public List<Integer> getSlotOrder(class_1263 container, @Nullable SlotRange range) {
        Iterator<Integer> rangeIter;
        InventoryUtils.validateContainer(container, true);
        int minSlot = 0;
        int maxSlot = container.method_5439() - 1;
        if (range != null && (rangeIter = range.getSlots(container).iterator()).hasNext()) {
            maxSlot = minSlot = rangeIter.next().intValue();
            while (rangeIter.hasNext()) {
                maxSlot = rangeIter.next();
            }
        }
        boolean isPlayerInventory = container instanceof class_1657;
        ArrayList<Integer> slots = new ArrayList<Integer>();
        switch (this.ordinal()) {
            case 0: {
                for (int i = minSlot; i <= maxSlot; ++i) {
                    slots.add(i);
                }
                break;
            }
            case 1: {
                for (int i = maxSlot; i >= minSlot; --i) {
                    slots.add(i);
                }
                break;
            }
            case 2: {
                int i;
                if (!isPlayerInventory) {
                    for (int i2 = minSlot; i2 <= maxSlot; ++i2) {
                        slots.add(i2);
                    }
                    break;
                }
                int hotbarEnd = Math.min(8, maxSlot);
                int mainInventoryEnd = Math.min(35, maxSlot);
                for (i = Math.max(0, minSlot); i <= hotbarEnd; ++i) {
                    slots.add(i);
                }
                if (minSlot <= 35) {
                    for (i = Math.max(9, minSlot); i <= mainInventoryEnd; ++i) {
                        slots.add(i);
                    }
                }
                if (maxSlot < 40 || minSlot > 40) break;
                slots.add(40);
                break;
            }
            case 3: {
                if (!isPlayerInventory) {
                    for (int i = minSlot; i <= maxSlot; ++i) {
                        slots.add(i);
                    }
                } else {
                    int i;
                    for (i = 36; i <= 39 && i <= maxSlot; ++i) {
                        if (i < minSlot) continue;
                        slots.add(i);
                    }
                    if (40 >= minSlot && 40 <= maxSlot) {
                        slots.add(40);
                    }
                    for (i = minSlot; i <= maxSlot; ++i) {
                        if (i >= 36 && i <= 40 || slots.contains(i)) continue;
                        slots.add(i);
                    }
                }
                break;
            }
        }
        return Collections.unmodifiableList(slots);
    }
}

