/*
 * Decompiled with CFR 0.152.
 */
package net.xun.lib.common.api.inventory;

import java.util.function.IntPredicate;
import net.xun.lib.common.api.inventory.slot.SlotRange;

public enum PlayerInventorySection {
    HOTBAR(0, 9),
    MAIN_INVENTORY(9, 36),
    ARMOR(36, 40),
    OFFHAND(40, 41),
    ALL(0, 41);

    private final int start;
    private final int end;
    private final IntPredicate checker;

    private PlayerInventorySection(int start, int end) {
        this.start = start;
        this.end = end;
        this.checker = slot -> slot >= start && slot < end;
    }

    public int getStart() {
        return this.start;
    }

    public int getEnd() {
        return this.end;
    }

    public SlotRange getSlotRange() {
        return new SlotRange(() -> this.start, () -> this.end);
    }

    public boolean matches(int slot) {
        return this.checker.test(slot);
    }
}

