/*
 * Decompiled with CFR 0.152.
 */
package net.xun.lib.common.api.inventory.predicates;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_6862;

public interface InventoryPredicate
extends Predicate<class_1799> {
    public static final InventoryPredicate IS_DAMAGED = stack -> stack != null && stack.method_7986() && stack.method_7963();
    public static final InventoryPredicate IS_FULL_STACK = stack -> stack != null && !stack.method_7960() && stack.method_7947() >= stack.method_7914();
    public static final InventoryPredicate IS_EMPTY = stack -> stack == null || stack.method_7960();

    public static InventoryPredicate ofType(Class<? extends class_1792> itemType) {
        Objects.requireNonNull(itemType, "Item type class cannot be null");
        return stack -> itemType.isInstance(stack.method_7909());
    }

    public static InventoryPredicate allOf(List<InventoryPredicate> predicates) {
        return stack -> predicates.stream().allMatch(p -> p.test(stack));
    }

    public static InventoryPredicate allOf(InventoryPredicate ... predicates) {
        return InventoryPredicate.allOf(Arrays.asList(predicates));
    }

    public static InventoryPredicate allOf(InventoryPredicate predicate1, InventoryPredicate predicate2) {
        return stack -> predicate1.test(stack) && predicate2.test(stack);
    }

    public static InventoryPredicate anyOf(List<InventoryPredicate> predicates) {
        return stack -> predicates.stream().anyMatch(p -> p.test(stack));
    }

    public static InventoryPredicate anyOf(InventoryPredicate ... predicates) {
        return InventoryPredicate.anyOf(Arrays.asList(predicates));
    }

    public static InventoryPredicate anyOf(InventoryPredicate predicate1, InventoryPredicate predicate2) {
        return stack -> predicate1.test(stack) || predicate2.test(stack);
    }

    public static InventoryPredicate matchesItem(List<class_1792> items) {
        return stack -> {
            if (stack == null) return false;
            if (stack.method_7960()) return false;
            if (!items.stream().anyMatch(arg_0 -> ((class_1799)stack).method_31574(arg_0))) return false;
            return true;
        };
    }

    public static InventoryPredicate matchesItem(class_1792 ... items) {
        return stack -> {
            if (stack == null) return false;
            if (stack.method_7960()) return false;
            if (!Arrays.stream(items).anyMatch(arg_0 -> ((class_1799)stack).method_31574(arg_0))) return false;
            return true;
        };
    }

    public static InventoryPredicate matchesItem(class_1792 item) {
        return stack -> stack != null && !stack.method_7960() && stack.method_31574(item);
    }

    public static InventoryPredicate matchesTag(class_6862<class_1792> itemTag) {
        return stack -> stack != null && !stack.method_7960() && stack.method_31573(itemTag);
    }

    default public InventoryPredicate and(InventoryPredicate other) {
        return stack -> this.test(stack) && other.test(stack);
    }

    default public InventoryPredicate or(InventoryPredicate other) {
        return stack -> this.test(stack) || other.test(stack);
    }

    public static InventoryPredicate not(InventoryPredicate predicate) {
        return stack -> !predicate.test(stack);
    }
}

