/*
 * Decompiled with CFR 0.152.
 */
package net.xun.lib.common.api.inventory.slot;

import java.util.Arrays;
import java.util.function.IntSupplier;
import java.util.stream.IntStream;
import net.minecraft.class_1263;
import net.xun.lib.common.api.inventory.slot.SlotIterator;

public class SlotRange {
    private final IntSupplier startSupplier;
    private final IntSupplier endSupplier;

    public SlotRange(IntSupplier startSupplier, IntSupplier endSupplier) {
        this.startSupplier = startSupplier;
        this.endSupplier = endSupplier;
    }

    public int getStart() {
        return this.startSupplier.getAsInt();
    }

    public int getEnd() {
        return this.endSupplier.getAsInt();
    }

    public static SlotRange of(int start, int end) {
        if (start > end) {
            throw new IllegalArgumentException("Start must be <= end");
        }
        return new SlotRange(() -> start, () -> end);
    }

    public static SlotRange single(int slot) {
        return new SlotRange(() -> slot, () -> slot + 1);
    }

    public boolean contains(int slot, class_1263 container) {
        int containerSize = container.method_5439();
        int safeStart = Math.min(this.startSupplier.getAsInt(), containerSize);
        int safeEnd = Math.min(this.endSupplier.getAsInt(), containerSize);
        return slot >= safeStart && slot < safeEnd;
    }

    public IntStream stream(class_1263 container) {
        int safeEnd;
        int containerSize = container.method_5439();
        int rawStart = this.startSupplier.getAsInt();
        int rawEnd = this.endSupplier.getAsInt();
        int safeStart = Math.min(rawStart, containerSize);
        if (safeStart > (safeEnd = Math.min(rawEnd, containerSize))) {
            int temp = safeStart;
            safeStart = safeEnd;
            safeEnd = temp;
        }
        return IntStream.range(safeStart, safeEnd);
    }

    public static SlotRange combine(SlotRange ... ranges) {
        return new SlotRange(() -> Arrays.stream(ranges).mapToInt(r -> r.startSupplier.getAsInt()).min().orElse(0), () -> Arrays.stream(ranges).mapToInt(r -> r.endSupplier.getAsInt()).max().orElse(0));
    }

    public Iterable<Integer> getSlots(class_1263 container) {
        int containerSize = container.method_5439();
        int rawStart = this.startSupplier.getAsInt();
        int rawEnd = this.endSupplier.getAsInt();
        int safeStart = Math.max(0, Math.min(rawStart, containerSize));
        int safeEnd = Math.max(0, Math.min(rawEnd, containerSize));
        return () -> new SlotIterator(safeStart, safeEnd);
    }
}

