/*
 * Decompiled with CFR 0.152.
 */
package net.xun.lib.common.api.item.armor;

import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.class_1738;
import net.minecraft.class_1741;
import net.minecraft.class_1792;
import net.minecraft.class_6880;
import net.xun.lib.common.api.item.armor.ArmorConfigurator;
import net.xun.lib.common.api.item.armor.ArmorType;
import net.xun.lib.common.internal.item.ItemRegistrar;
import net.xun.lib.common.internal.platform.RegistrationServices;

public class ArmorSet {
    private final String name;
    private final class_6880<class_1741> material;
    private final int durabilityFactor;
    private final class_1792.class_1793 properties;
    private final ArmorConfigurator configuration;
    private final Map<ArmorType, Supplier<? extends class_1792>> armors = new EnumMap<ArmorType, Supplier<? extends class_1792>>(ArmorType.class);
    private final ItemRegistrar registrar;

    public ArmorSet(String name, class_6880<class_1741> material, int durabilityFactor, class_1792.class_1793 properties, ArmorConfigurator configuration, ItemRegistrar registrar) {
        this.name = name;
        this.material = material;
        this.durabilityFactor = durabilityFactor;
        this.properties = properties;
        this.configuration = configuration;
        this.registrar = registrar;
    }

    public ArmorSet registerAll() {
        for (ArmorType type : ArmorType.values()) {
            this.armors.put(type, this.registrar.registerItem(this.name + type.getSuffix(), () -> this.configuration.createArmor(type, this.material, this.durabilityFactor, this.properties)));
        }
        return this;
    }

    public Supplier<class_1738> helmet() {
        return this.getPiece(ArmorType.HELMET);
    }

    public Supplier<class_1738> chestplate() {
        return this.getPiece(ArmorType.CHESTPLATE);
    }

    public Supplier<class_1738> leggings() {
        return this.getPiece(ArmorType.LEGGINGS);
    }

    public Supplier<class_1738> boots() {
        return this.getPiece(ArmorType.BOOTS);
    }

    private Supplier<class_1738> getPiece(ArmorType type) {
        return this.armors.get((Object)type);
    }

    public List<class_1792> getAll() {
        return this.armors.values().stream().map(Supplier::get).collect(Collectors.toList());
    }

    public static class Builder {
        private final String name;
        private final class_6880<class_1741> material;
        private int durabilityFactor;
        private class_1792.class_1793 properties;
        private ArmorConfigurator configuration = ArmorConfigurator.DEFAULT;
        private final ItemRegistrar registrar;

        public Builder(String name, class_6880<class_1741> material) {
            this.name = name;
            this.material = material;
            this.registrar = RegistrationServices.getItemRegistrar();
        }

        public Builder withDurabilityFactor(int durabilityFactor) {
            this.durabilityFactor = durabilityFactor;
            return this;
        }

        public Builder withItemProperties(class_1792.class_1793 properties) {
            this.properties = properties;
            return this;
        }

        public Builder withConfiguration(ArmorConfigurator configuration) {
            this.configuration = configuration;
            return this;
        }

        public ArmorSet build() {
            return new ArmorSet(this.name, this.material, this.durabilityFactor, this.properties, this.configuration, this.registrar);
        }
    }
}

