/*
 * Decompiled with CFR 0.152.
 */
package net.xun.lib.common.api.item.fuzzy;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.class_1792;
import net.minecraft.class_6862;
import net.minecraft.class_9331;
import net.xun.lib.common.api.inventory.predicates.InventoryPredicate;

public class FuzzyConfig {
    boolean ignoreDurability = false;
    boolean ignoreEnchantments = false;
    CountMode countMode = CountMode.EXACT;
    Predicate<class_9331<?>> componentFilter = c -> true;
    class_6862<class_1792> requiredTag = null;
    List<InventoryPredicate> predicates = new ArrayList<InventoryPredicate>();

    public FuzzyConfig withIgnoreDurability(boolean value) {
        FuzzyConfig copy = this.copy();
        copy.ignoreDurability = value;
        return copy;
    }

    public FuzzyConfig withIgnoreEnchantments(boolean value) {
        FuzzyConfig copy = this.copy();
        copy.ignoreEnchantments = value;
        return copy;
    }

    public FuzzyConfig withCountMode(CountMode countMode) {
        FuzzyConfig copy = this.copy();
        copy.countMode = countMode;
        return copy;
    }

    public FuzzyConfig withComponentFilter(FilterMode mode, Set<class_9331<?>> components) {
        FuzzyConfig copy = this.copy();
        copy.componentFilter = mode == FilterMode.WHITELIST ? components::contains : c -> !components.contains(c);
        return copy;
    }

    @Deprecated(since="1.3")
    public FuzzyConfig addCustomRule(InventoryPredicate rule) {
        FuzzyConfig copy = this.copy();
        copy.predicates.add(rule);
        return copy;
    }

    public FuzzyConfig withPredicateFilter(FilterMode mode, List<InventoryPredicate> predicates) {
        if (!(mode != FilterMode.WHITELIST && mode != FilterMode.BLACKLIST || predicates != null && !predicates.isEmpty())) {
            throw new IllegalArgumentException("Predicates cannot be empty for WHITELIST or BLACKLIST modes");
        }
        FuzzyConfig copy = this.copy();
        if (mode == FilterMode.WHITELIST) {
            copy.predicates = new ArrayList<InventoryPredicate>(predicates);
        } else if (mode == FilterMode.BLACKLIST) {
            ArrayList<InventoryPredicate> negatedPredicates = new ArrayList<InventoryPredicate>(predicates.size());
            for (InventoryPredicate p : predicates) {
                negatedPredicates.add(item -> !p.test(item));
            }
            copy.predicates = negatedPredicates;
        } else {
            copy.predicates.clear();
        }
        return copy;
    }

    public FuzzyConfig copy() {
        FuzzyConfig copy = new FuzzyConfig();
        copy.ignoreDurability = this.ignoreDurability;
        copy.ignoreEnchantments = this.ignoreEnchantments;
        copy.countMode = this.countMode;
        copy.componentFilter = this.componentFilter;
        copy.requiredTag = this.requiredTag;
        copy.predicates = new ArrayList<InventoryPredicate>(this.predicates);
        return copy;
    }

    public static enum CountMode {
        IGNORE,
        EXACT,
        AT_LEAST;

    }

    public static enum FilterMode {
        WHITELIST,
        BLACKLIST;

    }
}

