/*
 * Decompiled with CFR 0.152.
 */
package net.xun.lib.common.api.item.fuzzy;

import java.util.Objects;
import java.util.Set;
import net.minecraft.class_1799;
import net.xun.lib.common.api.exceptions.InvalidMatcherConfigurationException;
import net.xun.lib.common.api.item.fuzzy.FuzzyConfig;

public class FuzzyMatcher {
    public static final FuzzyMatcher BASIC = new FuzzyMatcher(new FuzzyConfig().withIgnoreDurability(true).withIgnoreEnchantments(true).withComponentFilter(FuzzyConfig.FilterMode.BLACKLIST, Set.of()));
    public static final FuzzyMatcher IGNORE_ALL = new FuzzyMatcher(new FuzzyConfig().withIgnoreDurability(true).withIgnoreEnchantments(true).withCountMode(FuzzyConfig.CountMode.IGNORE).withComponentFilter(FuzzyConfig.FilterMode.BLACKLIST, Set.of()));
    public static final FuzzyMatcher STRICT = new FuzzyMatcher(new FuzzyConfig());
    private final FuzzyConfig config;

    private FuzzyMatcher(FuzzyConfig config) {
        this.config = config;
    }

    public boolean matches(class_1799 a, class_1799 b) {
        this.validateConfiguration();
        if (a.method_7960() != b.method_7960()) {
            return false;
        }
        if (a.method_7960()) {
            return true;
        }
        return this.compareCore(a, b) && this.compareDurability(a, b) && this.compareEnchantments(a, b) && this.compareComponents(a, b) && this.compareCount(a, b) && this.validateCustomRules(a, b);
    }

    private boolean compareCore(class_1799 a, class_1799 b) {
        if (this.config.requiredTag != null) {
            return a.method_31573(this.config.requiredTag) && b.method_31573(this.config.requiredTag);
        }
        return a.method_7909() == b.method_7909();
    }

    private boolean compareDurability(class_1799 a, class_1799 b) {
        return this.config.ignoreDurability || a.method_7919() == b.method_7919();
    }

    private boolean compareEnchantments(class_1799 a, class_1799 b) {
        return this.config.ignoreEnchantments || Objects.equals(a.method_58657(), b.method_58657());
    }

    private boolean compareComponents(class_1799 a, class_1799 b) {
        return a.method_57353().method_57833().filter(entry -> this.config.componentFilter.test(entry.comp_2443())).allMatch(entry -> Objects.equals(entry.comp_2443(), b.method_57824(entry.comp_2443())));
    }

    private boolean compareCount(class_1799 a, class_1799 b) {
        return switch (this.config.countMode) {
            default -> throw new MatchException(null, null);
            case FuzzyConfig.CountMode.IGNORE -> true;
            case FuzzyConfig.CountMode.EXACT -> {
                if (a.method_7947() == b.method_7947()) {
                    yield true;
                }
                yield false;
            }
            case FuzzyConfig.CountMode.AT_LEAST -> a.method_7947() >= b.method_7947();
        };
    }

    private boolean validateCustomRules(class_1799 a, class_1799 b) {
        return this.config.predicates.stream().allMatch(rule -> rule.test(a) && rule.test(b));
    }

    private void validateConfiguration() {
        if (this.config.requiredTag != null && !this.config.predicates.isEmpty()) {
            throw new InvalidMatcherConfigurationException("Cannot combine tag requirements with custom rules");
        }
        if ((this.config.ignoreDurability || this.config.ignoreEnchantments || this.config.countMode != FuzzyConfig.CountMode.IGNORE) && !this.config.predicates.isEmpty()) {
            throw new InvalidMatcherConfigurationException("Cannot apply custom rules while ignoring attributes");
        }
    }
}

