/*
 * Decompiled with CFR 0.152.
 */
package net.xun.lib.common.api.item.tools;

import java.util.Arrays;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.class_1743;
import net.minecraft.class_1792;
import net.minecraft.class_1794;
import net.minecraft.class_1810;
import net.minecraft.class_1821;
import net.minecraft.class_1829;
import net.minecraft.class_1832;
import net.xun.lib.common.api.item.tools.AttributeHelper;
import net.xun.lib.common.api.item.tools.ToolConfigurator;
import net.xun.lib.common.api.item.tools.ToolType;
import net.xun.lib.common.internal.item.ItemRegistrar;
import net.xun.lib.common.internal.platform.RegistrationServices;

public class ToolSet {
    private final String name;
    private final class_1832 tier;
    private final EnumMap<ToolType, Float> attackDamage;
    private final EnumMap<ToolType, Float> attackSpeed;
    private final class_1792.class_1793 properties;
    private final ToolConfigurator configuration;
    private final Map<ToolType, Supplier<? extends class_1792>> tools = new EnumMap<ToolType, Supplier<? extends class_1792>>(ToolType.class);
    private final ItemRegistrar registrar;
    private final AttributeHelper attributeHelper;

    public ToolSet(String name, class_1832 tier, EnumMap<ToolType, Float> attackDamage, EnumMap<ToolType, Float> attackSpeed, class_1792.class_1793 properties, ToolConfigurator configuration, ItemRegistrar registrar, AttributeHelper attributeHelper) {
        this.name = name;
        this.tier = tier;
        this.attackDamage = attackDamage;
        this.attackSpeed = attackSpeed;
        this.properties = properties;
        this.configuration = configuration;
        this.registrar = registrar;
        this.attributeHelper = attributeHelper;
    }

    public ToolSet registerAll() {
        for (ToolType type : ToolType.values()) {
            float damage = this.attackDamage.get((Object)type).floatValue();
            float speed = this.attackSpeed.get((Object)type).floatValue();
            class_1792.class_1793 finalProperties = this.attributeHelper.applyAttributes(this.properties, this.tier.method_8028() + damage, speed);
            this.tools.put(type, this.registrar.registerItem(this.name + type.nameSuffix, () -> this.configuration.createTool(type, this.tier, this.properties)));
        }
        return this;
    }

    public Supplier<class_1829> getSword() {
        return this.tools.get((Object)ToolType.SWORD);
    }

    public Supplier<class_1743> getAxe() {
        return this.tools.get((Object)ToolType.AXE);
    }

    public Supplier<class_1810> getPickaxe() {
        return this.tools.get((Object)ToolType.PICKAXE);
    }

    public Supplier<class_1794> getHoe() {
        return this.tools.get((Object)ToolType.HOE);
    }

    public Supplier<class_1821> getShovel() {
        return this.tools.get((Object)ToolType.SHOVEL);
    }

    public List<class_1792> getAll() {
        return this.tools.values().stream().map(supplier -> (class_1792)supplier.get()).toList();
    }

    public static class Builder {
        private final String name;
        private final class_1832 tier;
        private final EnumMap<ToolType, Float> attackDamage = new EnumMap(ToolType.class);
        private final EnumMap<ToolType, Float> attackSpeed = new EnumMap(ToolType.class);
        private class_1792.class_1793 properties = new class_1792.class_1793();
        private ToolConfigurator configuration = ToolConfigurator.DEFAULT;
        private final ItemRegistrar registrar;
        private final AttributeHelper attributeHelper;

        public Builder(String name, class_1832 tier, AttributeHelper attributeHelper) {
            this.name = name;
            this.tier = tier;
            this.registrar = RegistrationServices.getItemRegistrar();
            this.attributeHelper = attributeHelper;
            this.initializeDefaultStats();
        }

        private void initializeDefaultStats() {
            Arrays.stream(ToolType.values()).forEach(type -> {
                this.attackDamage.put((ToolType)((Object)type), Float.valueOf(0.0f));
                this.attackSpeed.put((ToolType)((Object)type), Float.valueOf(0.0f));
            });
        }

        public Builder withToolStats(float[] damages, float[] speeds) {
            this.validateArrayStats(damages, speeds);
            ToolType[] types = ToolType.values();
            for (int i = 0; i < types.length; ++i) {
                this.attackDamage.put(types[i], Float.valueOf(damages[i]));
                this.attackSpeed.put(types[i], Float.valueOf(speeds[i]));
            }
            return this;
        }

        public Builder withToolStats(ToolType type, float damage, float speed) {
            this.attackDamage.put(type, Float.valueOf(damage));
            this.attackSpeed.put(type, Float.valueOf(speed));
            return this;
        }

        public Builder withVanillaBalance() {
            return this.withToolStats(new float[]{3.0f, 5.0f, 1.0f, 1.5f, 1.0f}, new float[]{1.6f, 0.9f, 1.2f, 1.0f, 1.0f});
        }

        public Builder withItemProperties(class_1792.class_1793 properties) {
            this.properties = properties;
            return this;
        }

        public Builder withConfiguration(ToolConfigurator configurator) {
            this.configuration = configurator;
            return this;
        }

        public ToolSet build() {
            return new ToolSet(this.name, this.tier, this.attackDamage, this.attackSpeed, this.properties, this.configuration, this.registrar, this.attributeHelper);
        }

        private void validateArrayStats(float[] damages, float[] speeds) {
            int expected = ToolType.values().length;
            if (damages.length != expected || speeds.length != expected) {
                throw new IllegalArgumentException("Invalid stats array lengths. Expected " + expected + " elements. Tool order: " + Arrays.toString((Object[])ToolType.values()));
            }
        }
    }
}

