/*
 * Decompiled with CFR 0.152.
 */
package net.xun.lib.common.api.misc.color;

import net.xun.lib.common.api.misc.color.IColorBase;
import net.xun.lib.common.api.misc.color.RGBColor;

public class ColorCombiner {
    public static RGBColor blendAdd(IColorBase color1, IColorBase color2) {
        RGBColor rgb1 = color1.asRGB();
        RGBColor rgb2 = color2.asRGB();
        float red = ColorCombiner.clamp(rgb1.red() + rgb2.red());
        float green = ColorCombiner.clamp(rgb1.green() + rgb2.green());
        float blue = ColorCombiner.clamp(rgb1.blue() + rgb2.blue());
        return new RGBColor(red, green, blue);
    }

    public static RGBColor blendAverage(IColorBase color1, IColorBase color2) {
        RGBColor rgb1 = color1.asRGB();
        RGBColor rgb2 = color2.asRGB();
        float red = (rgb1.red() + rgb2.red()) / 2.0f;
        float green = (rgb1.green() + rgb2.green()) / 2.0f;
        float blue = (rgb1.blue() + rgb2.blue()) / 2.0f;
        return new RGBColor(red, green, blue);
    }

    public static RGBColor blendMultiply(IColorBase color1, IColorBase color2) {
        RGBColor rgb1 = color1.asRGB();
        RGBColor rgb2 = color2.asRGB();
        float red = rgb1.red() * rgb2.red() / 255.0f;
        float green = rgb1.green() * rgb2.green() / 255.0f;
        float blue = rgb1.blue() * rgb2.blue() / 255.0f;
        return new RGBColor(red, green, blue);
    }

    public static RGBColor blendScreen(IColorBase color1, IColorBase color2) {
        RGBColor rgb1 = color1.asRGB();
        RGBColor rgb2 = color2.asRGB();
        float red = 255.0f - (255.0f - rgb1.red()) * (255.0f - rgb2.red()) / 255.0f;
        float green = 255.0f - (255.0f - rgb1.green()) * (255.0f - rgb2.green()) / 255.0f;
        float blue = 255.0f - (255.0f - rgb1.blue()) * (255.0f - rgb2.blue()) / 255.0f;
        return new RGBColor(red, green, blue);
    }

    public static RGBColor blendOverlay(IColorBase color1, IColorBase color2) {
        RGBColor rgb1 = color1.asRGB();
        RGBColor rgb2 = color2.asRGB();
        float red = ColorCombiner.calculateOverlay(rgb1.red(), rgb2.red());
        float green = ColorCombiner.calculateOverlay(rgb1.green(), rgb2.green());
        float blue = ColorCombiner.calculateOverlay(rgb1.blue(), rgb2.blue());
        return new RGBColor(red, green, blue);
    }

    private static float calculateOverlay(float base, float blend) {
        if (base < 128.0f) {
            return 2.0f * base * blend / 255.0f;
        }
        return 255.0f - 2.0f * (255.0f - base) * (255.0f - blend) / 255.0f;
    }

    public static RGBColor blendLighten(IColorBase color1, IColorBase color2) {
        RGBColor rgb1 = color1.asRGB();
        RGBColor rgb2 = color2.asRGB();
        float red = Math.max(rgb1.red(), rgb2.red());
        float green = Math.max(rgb1.green(), rgb2.green());
        float blue = Math.max(rgb1.blue(), rgb2.blue());
        return new RGBColor(red, green, blue);
    }

    public static RGBColor blendDarken(IColorBase color1, IColorBase color2) {
        RGBColor rgb1 = color1.asRGB();
        RGBColor rgb2 = color2.asRGB();
        float red = Math.min(rgb1.red(), rgb2.red());
        float green = Math.min(rgb1.green(), rgb2.green());
        float blue = Math.min(rgb1.blue(), rgb2.blue());
        return new RGBColor(red, green, blue);
    }

    private static float clamp(float value) {
        return Math.max(0.0f, Math.min(255.0f, value));
    }
}

