/*
 * Decompiled with CFR 0.152.
 */
package net.xun.lib.common.api.misc.color;

import net.xun.lib.common.api.misc.color.HSLColor;
import net.xun.lib.common.api.misc.color.HSVColor;
import net.xun.lib.common.api.misc.color.RGBColor;

public class ColorConverter {
    public static HSLColor RGBtoHSL(RGBColor rgb) {
        float s;
        float rf = rgb.red() / 255.0f;
        float gf = rgb.green() / 255.0f;
        float bf = rgb.blue() / 255.0f;
        float max = Math.max(rf, Math.max(gf, bf));
        float min = Math.min(rf, Math.min(gf, bf));
        float delta = max - min;
        float h = 0.0f;
        float l = (max + min) / 2.0f;
        if (delta != 0.0f) {
            s = delta / (1.0f - Math.abs(2.0f * l - 1.0f));
            h = max == rf ? (gf - bf) / delta % 6.0f : (max == gf ? (bf - rf) / delta + 2.0f : (rf - gf) / delta + 4.0f);
            if ((h *= 60.0f) < 0.0f) {
                h += 360.0f;
            }
        } else {
            s = 0.0f;
        }
        return new HSLColor(h, s, l);
    }

    public static RGBColor HSLtoRGB(HSLColor hsl) {
        float g1;
        float r1;
        float hue = hsl.hue() / 360.0f;
        float saturation = hsl.saturation();
        float lightness = hsl.lightness();
        if (saturation == 0.0f) {
            int gray = Math.round(lightness * 255.0f);
            return new RGBColor(gray, gray, gray);
        }
        float chroma = (1.0f - Math.abs(2.0f * lightness - 1.0f)) * saturation;
        float hPrime = hue * 6.0f;
        float x = chroma * (1.0f - Math.abs(hPrime % 2.0f - 1.0f));
        int sector = (int)hPrime;
        float b1 = switch (sector) {
            case 0 -> {
                r1 = chroma;
                g1 = x;
                yield 0.0f;
            }
            case 1 -> {
                r1 = x;
                g1 = chroma;
                yield 0.0f;
            }
            case 2 -> {
                r1 = 0.0f;
                g1 = chroma;
                yield x;
            }
            case 3 -> {
                r1 = 0.0f;
                g1 = x;
                yield chroma;
            }
            case 4 -> {
                r1 = x;
                g1 = 0.0f;
                yield chroma;
            }
            default -> {
                r1 = chroma;
                g1 = 0.0f;
                yield x;
            }
        };
        float m = lightness - chroma / 2.0f;
        int red = Math.round((r1 + m) * 255.0f);
        int green = Math.round((g1 + m) * 255.0f);
        int blue = Math.round((b1 + m) * 255.0f);
        return new RGBColor(red, green, blue);
    }

    public static HSVColor RGBtoHSV(RGBColor rgb) {
        float s;
        float r = rgb.red() / 255.0f;
        float g = rgb.green() / 255.0f;
        float b = rgb.blue() / 255.0f;
        float max = Math.max(r, Math.max(g, b));
        float min = Math.min(r, Math.min(g, b));
        float delta = max - min;
        float h = 0.0f;
        float v = max;
        if (delta != 0.0f) {
            s = delta / max;
            h = max == r ? (g - b) / delta % 6.0f : (max == g ? (b - r) / delta + 2.0f : (r - g) / delta + 4.0f);
            if ((h *= 60.0f) < 0.0f) {
                h += 360.0f;
            }
        } else {
            s = 0.0f;
        }
        return new HSVColor(h, s, v);
    }

    public static RGBColor HSVtoRGB(HSVColor hsv) {
        float g1;
        float r1;
        float h = hsv.hue() % 360.0f;
        float s = hsv.saturation();
        float v = hsv.value();
        if (s == 0.0f) {
            int gray = Math.round(v * 255.0f);
            return new RGBColor(gray, gray, gray);
        }
        float chroma = v * s;
        float hPrime = h / 60.0f;
        int sector = (int)hPrime;
        float x = chroma * (1.0f - Math.abs(hPrime % 2.0f - 1.0f));
        float b1 = switch (sector) {
            case 0 -> {
                r1 = chroma;
                g1 = x;
                yield 0.0f;
            }
            case 1 -> {
                r1 = x;
                g1 = chroma;
                yield 0.0f;
            }
            case 2 -> {
                r1 = 0.0f;
                g1 = chroma;
                yield x;
            }
            case 3 -> {
                r1 = 0.0f;
                g1 = x;
                yield chroma;
            }
            case 4 -> {
                r1 = x;
                g1 = 0.0f;
                yield chroma;
            }
            default -> {
                r1 = chroma;
                g1 = 0.0f;
                yield x;
            }
        };
        float m = v - chroma;
        return new RGBColor(Math.round((r1 + m) * 255.0f), Math.round((g1 + m) * 255.0f), Math.round((b1 + m) * 255.0f));
    }
}

