/*
 * Decompiled with CFR 0.152.
 */
package net.xun.lib.common.api.misc.color;

import net.xun.lib.common.api.exceptions.InvalidColorFormatException;
import net.xun.lib.common.api.misc.color.ColorConverter;
import net.xun.lib.common.api.misc.color.IColorBase;
import net.xun.lib.common.api.misc.color.RGBColor;

public record HSLColor(float hue, float saturation, float lightness) implements IColorBase
{
    public HSLColor(float hue, float saturation, float lightness) {
        this.validateParameters();
        this.hue = hue;
        this.saturation = saturation;
        this.lightness = lightness;
    }

    @Override
    public RGBColor asRGB() {
        return ColorConverter.HSLtoRGB(this);
    }

    @Override
    public String asHex() {
        return this.asRGB().asHex();
    }

    private void validateParameters() {
        if (this.hue < 0.0f || this.hue > 360.0f) {
            throw new InvalidColorFormatException("Hue must be between 0 and 360");
        }
        if (this.saturation < 0.0f || this.saturation > 1.0f) {
            throw new InvalidColorFormatException("Saturation must be between 0 and 1");
        }
        if (this.lightness < 0.0f || this.lightness > 1.0f) {
            throw new InvalidColorFormatException("Lightness must be between 0 and 1");
        }
    }
}

