/*
 * Decompiled with CFR 0.152.
 */
package net.xun.lib.common.api.misc.color;

import net.xun.lib.common.api.exceptions.InvalidColorFormatException;
import net.xun.lib.common.api.misc.color.ColorConverter;
import net.xun.lib.common.api.misc.color.IColorBase;
import net.xun.lib.common.api.misc.color.RGBColor;

public record HSVColor(float hue, float saturation, float value) implements IColorBase
{
    public HSVColor(float hue, float saturation, float value) {
        this.validateParameters();
        this.hue = hue;
        this.saturation = saturation;
        this.value = value;
    }

    @Override
    public RGBColor asRGB() {
        return ColorConverter.HSVtoRGB(this);
    }

    @Override
    public String asHex() {
        return this.asRGB().asHex();
    }

    private void validateParameters() {
        if (this.hue < 0.0f || this.hue > 360.0f) {
            throw new InvalidColorFormatException("Hue must be between 0 and 360");
        }
        if (this.saturation < 0.0f || this.saturation > 1.0f) {
            throw new InvalidColorFormatException("Saturation must be between 0 and 1");
        }
        if (this.value < 0.0f || this.value > 1.0f) {
            throw new InvalidColorFormatException("Value must be between 0 and 1");
        }
    }
}

