/*
 * Decompiled with CFR 0.152.
 */
package net.xun.lib.common.api.misc.color;

import net.xun.lib.common.api.exceptions.InvalidColorFormatException;
import net.xun.lib.common.api.misc.color.IColorBase;

public record RGBColor(float red, float green, float blue) implements IColorBase
{
    public RGBColor {
        if (red < 0.0f || red > 255.0f || green < 0.0f || green > 255.0f || blue < 0.0f || blue > 255.0f) {
            throw new InvalidColorFormatException("RGB components must be between 0 and 255");
        }
    }

    @Override
    public String asHex() {
        return String.format("#%02X%02X%02X", Math.round(this.red), Math.round(this.green), Math.round(this.blue));
    }

    @Override
    public RGBColor asRGB() {
        return this;
    }
}

