/*
 * Decompiled with CFR 0.152.
 */
package net.xun.lib.common.api.util;

import java.util.Arrays;
import java.util.Collection;
import net.minecraft.class_1304;
import net.minecraft.class_1657;
import net.minecraft.class_1738;
import net.minecraft.class_1741;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_6880;
import net.xun.lib.common.api.exceptions.UtilityClassException;
import net.xun.lib.common.api.inventory.predicates.InventoryPredicate;

public class ArmorSlotsUtils {
    private static final int[] ALL_ARMOR_SLOTS = new int[]{class_1304.field_6169.method_5927(), class_1304.field_6174.method_5927(), class_1304.field_6172.method_5927(), class_1304.field_6166.method_5927()};

    private ArmorSlotsUtils() throws UtilityClassException {
        throw new UtilityClassException();
    }

    public static boolean hasArmorInSlot(class_1657 player, int slotIndex) {
        return !ArmorSlotsUtils.getArmorInSlot(player, slotIndex).method_7960();
    }

    public static boolean hasFullArmorSet(class_1657 player) {
        return Arrays.stream(ALL_ARMOR_SLOTS).allMatch(slot -> ArmorSlotsUtils.hasArmorInSlot(player, slot));
    }

    public static boolean isArmorMaterialInSlot(class_1657 player, int slotIndex, class_6880<class_1741> material) {
        class_1738 item;
        class_1799 armor = ArmorSlotsUtils.getArmorInSlot(player, slotIndex);
        class_1792 class_17922 = armor.method_7909();
        return class_17922 instanceof class_1738 && (item = (class_1738)class_17922).method_7686() == material;
    }

    public static boolean hasFullArmorSetOfMaterial(class_1657 player, class_6880<class_1741> material) {
        return Arrays.stream(ALL_ARMOR_SLOTS).allMatch(slot -> ArmorSlotsUtils.isArmorMaterialInSlot(player, slot, material));
    }

    public static boolean hasEnchantmentInSlot(class_1657 player, int slotIndex) {
        class_1799 armor = ArmorSlotsUtils.getArmorInSlot(player, slotIndex);
        return !armor.method_58657().method_57543();
    }

    public static float getArmorDurabilityPercentage(class_1657 player, int slotIndex) {
        class_1799 armor = ArmorSlotsUtils.getArmorInSlot(player, slotIndex);
        if (armor.method_7960()) {
            return 0.0f;
        }
        return (float)(armor.method_7936() - armor.method_7919()) / (float)armor.method_7936();
    }

    public static boolean matchesInSlot(class_1657 player, int slotIndex, InventoryPredicate condition) {
        return condition.test(ArmorSlotsUtils.getArmorInSlot(player, slotIndex));
    }

    public static boolean matchesAllArmor(class_1657 player, InventoryPredicate condition) {
        return Arrays.stream(ALL_ARMOR_SLOTS).allMatch(slot -> ArmorSlotsUtils.matchesInSlot(player, slot, condition));
    }

    public static class_1799 getArmorInSlot(class_1657 player, int slotIndex) {
        return player.method_31548().method_7372(slotIndex);
    }

    public static Collection<class_1799> getAllWornArmor(class_1657 player) {
        return Arrays.stream(ALL_ARMOR_SLOTS).mapToObj(slot -> ArmorSlotsUtils.getArmorInSlot(player, slot)).filter(stack -> !stack.method_7960()).toList();
    }

    public static int countArmorPiecesOfMaterial(class_1657 player, class_6880<class_1741> material) {
        return (int)Arrays.stream(ALL_ARMOR_SLOTS).filter(slot -> ArmorSlotsUtils.isArmorMaterialInSlot(player, slot, material)).count();
    }

    public static boolean hasSetBonus(class_1657 player, class_6880<class_1741> material, int requiredPieces) {
        return ArmorSlotsUtils.countArmorPiecesOfMaterial(player, material) >= requiredPieces;
    }

    public static boolean needsRepair(int slotIndex, class_1657 player) {
        class_1799 armor = ArmorSlotsUtils.getArmorInSlot(player, slotIndex);
        return armor.method_7986();
    }

    public static int countDamagedPieces(class_1657 player) {
        return (int)Arrays.stream(ALL_ARMOR_SLOTS).filter(slot -> ArmorSlotsUtils.matchesInSlot(player, slot, InventoryPredicate.IS_DAMAGED)).count();
    }
}

