/*
 * Decompiled with CFR 0.152.
 */
package net.xun.lib.common.api.util;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_1263;
import net.minecraft.class_1297;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2586;
import net.xun.lib.common.api.exceptions.UtilityClassException;
import net.xun.lib.common.api.inventory.InventoryCycleOrder;
import net.xun.lib.common.api.inventory.predicates.InventoryPredicate;
import net.xun.lib.common.api.inventory.slot.SlotIterator;
import net.xun.lib.common.api.inventory.slot.SlotRange;
import org.jetbrains.annotations.Nullable;

public class InventoryUtils {
    private InventoryUtils() throws UtilityClassException {
        throw new UtilityClassException();
    }

    public static boolean hasItemCount(class_1263 container, InventoryPredicate predicate, int minCount, @Nullable SlotRange slots) {
        InventoryUtils.validateContainer(container);
        Objects.requireNonNull(predicate, "Predicate cannot be null");
        if (minCount < 1) {
            throw new IllegalArgumentException("minCount must be \u22651");
        }
        int count = 0;
        for (int slot : InventoryUtils.getSlotIterator(container, slots)) {
            class_1799 stack = container.method_5438(slot);
            if (stack.method_7960() || !predicate.test(stack) || (count += stack.method_7947()) < minCount) continue;
            return true;
        }
        return false;
    }

    public static boolean hasItem(class_1263 container, InventoryPredicate predicate, @Nullable SlotRange slots) {
        return InventoryUtils.hasItemCount(container, predicate, 1, slots);
    }

    public static int findFirstMatchingSlot(class_1263 container, InventoryPredicate predicate, @Nullable SlotRange slots) {
        InventoryUtils.validateContainer(container);
        Objects.requireNonNull(predicate, "Predicate cannot be null");
        for (int slot : InventoryUtils.getSlotIterator(container, slots)) {
            class_1799 stack = container.method_5438(slot);
            if (stack.method_7960() || !predicate.test(stack)) continue;
            return slot;
        }
        return -1;
    }

    public static class_1799 getItemInSlot(class_1263 container, int slotIndex) {
        return container.method_5438(slotIndex);
    }

    public static void extractItems(class_1263 container, InventoryPredicate predicate, int amount, @Nullable SlotRange slots, InventoryCycleOrder order) {
        InventoryUtils.validateContainer(container);
        Objects.requireNonNull(predicate, "Predicate cannot be null");
        Objects.requireNonNull(order, "Removal order cannot be null");
        if (amount < 1) {
            throw new IllegalArgumentException("Amount must be \u22651");
        }
        List<Integer> slotOrder = order.getSlotOrder(container, slots);
        int remaining = amount;
        for (int slot : slotOrder) {
            class_1799 stack = container.method_5438(slot);
            if (stack.method_7960() || !predicate.test(stack)) continue;
            int remove = Math.min(stack.method_7947(), remaining);
            stack.method_7934(remove);
            remaining -= remove;
            if (stack.method_7960()) {
                container.method_5447(slot, class_1799.field_8037);
            }
            if (remaining > 0) continue;
            break;
        }
    }

    public static void extractSingleItem(class_1263 container, InventoryPredicate predicate, SlotRange slots, InventoryCycleOrder order) {
        InventoryUtils.extractItems(container, predicate, 1, slots, order);
    }

    public static class_1799 insertItem(class_1263 container, class_1799 stack) {
        InventoryUtils.validateContainer(container);
        Objects.requireNonNull(stack, "ItemStack cannot be null");
        if (stack.method_7960()) {
            return class_1799.field_8037;
        }
        class_1799 remaining = stack.method_7972();
        if ((remaining = InventoryUtils.tryMergeWithExisting(container, remaining)).method_7960()) {
            return class_1799.field_8037;
        }
        remaining = InventoryUtils.tryFillEmptySlots(container, remaining);
        return remaining;
    }

    public static void insertAndDiscardOverflow(class_1263 container, class_1799 stack) {
        InventoryUtils.insertItem(container, stack);
    }

    public static ImmutableList<class_1799> collectMatching(class_1263 container, InventoryPredicate predicate, @Nullable SlotRange slots) {
        InventoryUtils.validateContainer(container);
        Objects.requireNonNull(predicate, "Predicate cannot be null");
        ArrayList<class_1799> matches = new ArrayList<class_1799>();
        for (int slot : InventoryUtils.getSlotIterator(container, slots)) {
            class_1799 stack = container.method_5438(slot);
            if (stack.method_7960() || !predicate.test(stack)) continue;
            matches.add(stack.method_7972());
        }
        return ImmutableList.copyOf(matches);
    }

    public static int getAvailableSpace(class_1263 container) {
        InventoryUtils.validateContainer(container);
        int space = 0;
        for (int slot = 0; slot < container.method_5439(); ++slot) {
            class_1799 existing = container.method_5438(slot);
            if (!existing.method_7960()) continue;
            ++space;
        }
        return space;
    }

    private static Iterable<Integer> getSlotIterator(class_1263 container, @Nullable SlotRange range) {
        return range != null ? range.getSlots(container) : () -> new SlotIterator(0, container.method_5439());
    }

    private static class_1799 tryMergeWithExisting(class_1263 container, class_1799 stack) {
        class_1799 remaining = stack.method_7972();
        for (int slot = 0; slot < container.method_5439(); ++slot) {
            int transfer;
            class_1799 existing = container.method_5438(slot);
            if (!class_1799.method_7984((class_1799)existing, (class_1799)remaining) || (transfer = Math.min(remaining.method_7947(), existing.method_7914() - existing.method_7947())) <= 0) continue;
            existing.method_7933(transfer);
            remaining.method_7934(transfer);
            container.method_5447(slot, existing);
            if (!remaining.method_7960()) continue;
            return class_1799.field_8037;
        }
        return remaining;
    }

    private static class_1799 tryFillEmptySlots(class_1263 container, class_1799 stack) {
        class_1799 remaining = stack.method_7972();
        for (int slot = 0; slot < container.method_5439(); ++slot) {
            class_1799 existing = container.method_5438(slot);
            if (!existing.method_7960()) continue;
            int transfer = Math.min(remaining.method_7947(), remaining.method_7914());
            class_1799 newStack = remaining.method_7972();
            newStack.method_7939(transfer);
            container.method_5447(slot, newStack);
            remaining.method_7934(transfer);
            if (!remaining.method_7960()) continue;
            return class_1799.field_8037;
        }
        return remaining;
    }

    public static void validateContainer(class_1263 container, boolean allowClientSide) {
        Objects.requireNonNull(container, "Container cannot be null");
        class_1937 level = null;
        if (container instanceof class_1297) {
            class_1297 e = (class_1297)container;
            level = e.method_37908();
        } else if (container instanceof class_2586) {
            class_2586 be = (class_2586)container;
            level = be.method_10997();
        }
        if (!allowClientSide && level != null && level.field_9236) {
            throw new IllegalStateException("Client-side inventory modifications are not allowed");
        }
        int size = container.method_5439();
        if (size <= 0) {
            throw new IllegalArgumentException("Container has invalid size: " + size);
        }
        try {
            container.method_5438(0);
            if (size > 1) {
                container.method_5438(size - 1);
            }
        }
        catch (IndexOutOfBoundsException e) {
            throw new IllegalArgumentException("Container slot access violation", e);
        }
    }

    public static void validateContainer(class_1263 container) {
        InventoryUtils.validateContainer(container, false);
    }
}

