/*
 * Decompiled with CFR 0.152.
 */
package net.xun.lib.common.api.util;

import java.util.List;
import net.minecraft.class_1293;
import net.minecraft.class_1309;
import net.xun.lib.common.api.exceptions.UtilityClassException;
import net.xun.lib.common.api.world.effect.EffectStackingStrategy;

public class MobEffectUtils {
    private MobEffectUtils() throws UtilityClassException {
        throw new UtilityClassException();
    }

    public static void applyEffectsWithStrategy(class_1309 entity, List<class_1293> effects, EffectStackingStrategy strategy) {
        effects.forEach(e -> strategy.apply(entity, (class_1293)e));
    }

    public static void applySmartEffects(class_1309 entity, List<class_1293> effects, int expiryThreshold, boolean forceAdd) {
        if (entity == null || effects == null || effects.isEmpty()) {
            return;
        }
        boolean shouldApply = effects.stream().noneMatch(e -> MobEffectUtils.hasSufficientEffect(entity, e, expiryThreshold));
        if (shouldApply) {
            effects.forEach(e -> MobEffectUtils.applySingleEffect(entity, e, expiryThreshold, forceAdd));
        }
    }

    public static void applySingleEffect(class_1309 entity, class_1293 effect, int expiryThreshold, boolean forceAdd) {
        if (forceAdd || !MobEffectUtils.hasSufficientEffect(entity, effect, expiryThreshold)) {
            entity.method_6092(new class_1293(effect.method_5579(), effect.method_5584(), effect.method_5578(), effect.method_5591(), effect.method_5581(), effect.method_5592()));
        }
    }

    public static boolean hasSufficientEffect(class_1309 entity, class_1293 effect, int expiryThreshold) {
        class_1293 current = entity.method_6112(effect.method_5579());
        if (current == null) {
            return false;
        }
        return !current.method_48557(expiryThreshold) && current.method_5578() >= effect.method_5578() && current.method_5584() >= effect.method_5584();
    }
}

